﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_2;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_3;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_3
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/エミッタタブ/エミッタ設定グループデータです。
    /// </summary>
    [Serializable]
    public class EmitterEmitterShapeData : DataModelBase
    {
        /// <summary>
        /// エミッタ半径, もしくは辺の長さを取得または設定します。
        /// </summary>
        private Vector3f emitterTypeEmitterRadius = null;

        /// <summary>
        /// スケールを取得または設定します。
        /// </summary>
        private Vector3f emitterScaleShapeScale = null;

        /// <summary>
        /// スケールのエミッタ時間アニメを取得または設定します。
        /// </summary>
        private EmitterAnimationCommonData shapeScaleAnimation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterEmitterShapeData() :
            base()
        {
            this.EmitterType = 0;
            this.EmitterTypeEmitterRadius = new Vector3f(1.0f, 1.0f, 1.0f);
            this.EmitterShapeLongitudeArcLength = 360.0f;
            this.EmitterShapeLatitudeArcLength = 180.0f;
            this.EmitterShapeStartArc = 0.0f;
            this.EmitterShapeStartArcRandom = false;
            this.EmitterShapeRandomPos = 0.0f;
            this.EmitterShapeHollowRatio = 0.0f;
            this.EmitterShapeArcType = 0;
            this.EmitterShapeLineCenter = 0.0f;
            this.EmitterShapeLineLength = 1.0f;
            this.EmitterShapeEmissionType = 0;
            this.EmitterShapeSphereAxis = 2;
            this.EmitterShapeSphereAndDivisionDivision = 0;
            this.EmitterShapeSphereAndDivision64Division = 4;
            this.EmitterShapeCircleDivision = 1;
            this.EmitterShapeCircleDivisionRandom = 0;
            this.EmitterShapeLineDivision = 1;
            this.EmitterShapeLineDivisionRandom = 0;
            this.EmitterScaleShapeScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.PrimitiveFilePath = string.Empty;
            this.RandomPosition = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// エミッタ形状を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("57060530-1832-4606-99e3-04b0397a4b62")]
        public int EmitterType { get; set; }

        /// <summary>
        /// エミッタ半径, もしくは辺の長さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b52fbefd-d776-48d1-8f3a-2a443c53a305")]
        public Vector3f EmitterTypeEmitterRadius
        {
            get { return this.GetObjectFromField(ref this.emitterTypeEmitterRadius, false); }
            set { this.SetISettableToField(ref this.emitterTypeEmitterRadius, value); }
        }

        /// <summary>
        /// 経度の弧の幅（角度）を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fb5cca22-e58c-467a-bbd1-51b11527c209")]
        public float EmitterShapeLongitudeArcLength { get; set; }

        /// <summary>
        /// 緯度の弧の幅（角度）を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c835f0b0-d3cf-4cea-bb9c-05cc811b684a")]
        public float EmitterShapeLatitudeArcLength { get; set; }

        /// <summary>
        /// 弧の開始角度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6ec1c64a-9826-4c6e-a452-4148ad9666ef")]
        public float EmitterShapeStartArc { get; set; }

        /// <summary>
        /// 弧の開始角度ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("39dfe493-c5ea-483b-88e0-858265c9025e")]
        public bool EmitterShapeStartArcRandom { get; set; }

        /// <summary>
        /// ランダム角度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5adf3683-3bea-4b37-b26c-0f58f7072d9b")]
        public float EmitterShapeRandomPos { get; set; }

        /// <summary>
        /// 空洞率(%)を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8a403650-39a9-4de6-aa46-9b82f608f90f")]
        public float EmitterShapeHollowRatio { get; set; }

        /// <summary>
        /// 弧の開き方を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b56dbaf4-ec97-47c9-b829-3e1153df2e91")]
        public int EmitterShapeArcType { get; set; }

        /// <summary>
        /// ラインの中心位置を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("96268159-7be2-448b-ad48-8dd00defe4ce")]
        public float EmitterShapeLineCenter { get; set; }

        /// <summary>
        /// ラインの長さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e3ed7182-a103-4b2f-9c5c-bb4b378bad30")]
        public float EmitterShapeLineLength { get; set; }

        /// <summary>
        /// 放出タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4eb1daff-7e94-48b6-a65e-dd8f2b8c4d25")]
        public int EmitterShapeEmissionType { get; set; }

        /// <summary>
        /// 緯度の軸を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6e39450e-7854-4754-bb8f-8395123ee931")]
        public int EmitterShapeSphereAxis { get; set; }

        /// <summary>
        /// 球（等分割）の分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8a095826-5248-440b-aadd-2364376b4913")]
        public int EmitterShapeSphereAndDivisionDivision { get; set; }

        /// <summary>
        /// 球（等分割64）の分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0ebecd54-c857-4e56-9dee-da2ad13539a2")]
        public int EmitterShapeSphereAndDivision64Division { get; set; }

        /// <summary>
        /// 円(等分割)の分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("32e764c6-f8cb-4ac3-ae73-31ab0f421e7f")]
        public int EmitterShapeCircleDivision { get; set; }

        /// <summary>
        /// 円(等分割)の分割数ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("8a412eff-dce2-4d80-8af7-907cfad2e054")]
        public int EmitterShapeCircleDivisionRandom { get; set; }

        /// <summary>
        /// ライン(等分割)の分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("db6cdfad-11b4-4112-82c3-533062f719db")]
        public int EmitterShapeLineDivision { get; set; }

        /// <summary>
        /// 円(等分割)の分割数ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c4877566-8ce6-45ea-b599-fa94b1fecd9a")]
        public int EmitterShapeLineDivisionRandom { get; set; }

        /// <summary>
        /// スケールを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3b128820-5139-4f0d-8117-d0d5f01b8bb7")]
        public Vector3f EmitterScaleShapeScale
        {
            get { return this.GetObjectFromField(ref this.emitterScaleShapeScale, false); }
            set { this.SetISettableToField(ref this.emitterScaleShapeScale, value); }
        }

        /// <summary>
        /// プリミティブのファイルパスを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d22026c5-73ff-427d-99e2-cb8a17496747")]
        public string PrimitiveFilePath { get; set; }

        /// <summary>
        /// 放出位置ランダムの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("204b115b-2dd2-4c23-9734-332526256643")]
        public float RandomPosition { get; set; }

        /// <summary>
        /// スケールのエミッタ時間アニメを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("22ade12c-c891-4804-85fc-44c7c85af7be")]
        public EmitterAnimationCommonData ShapeScaleAnimation
        {
            get { return this.GetDataModelFromField(ref this.shapeScaleAnimation, false); }
            set { this.SetDataModelToField(ref this.shapeScaleAnimation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterEmitterShapeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterType = srcDataModel.EmitterType;
            this.EmitterTypeEmitterRadius = srcDataModel.EmitterTypeEmitterRadius;
            this.EmitterShapeLongitudeArcLength = srcDataModel.EmitterShapeLongitudeArcLength;
            this.EmitterShapeLatitudeArcLength = srcDataModel.EmitterShapeLatitudeArcLength;
            this.EmitterShapeStartArc = srcDataModel.EmitterShapeStartArc;
            this.EmitterShapeStartArcRandom = srcDataModel.EmitterShapeStartArcRandom;
            this.EmitterShapeRandomPos = srcDataModel.EmitterShapeRandomPos;
            this.EmitterShapeHollowRatio = srcDataModel.EmitterShapeHollowRatio;
            this.EmitterShapeArcType = srcDataModel.EmitterShapeArcType;
            this.EmitterShapeLineCenter = srcDataModel.EmitterShapeLineCenter;
            this.EmitterShapeLineLength = srcDataModel.EmitterShapeLineLength;
            this.EmitterShapeEmissionType = srcDataModel.EmitterShapeEmissionType;
            this.EmitterShapeSphereAxis = srcDataModel.EmitterShapeSphereAxis;
            this.EmitterShapeSphereAndDivisionDivision = srcDataModel.EmitterShapeSphereAndDivisionDivision;
            this.EmitterShapeSphereAndDivision64Division = srcDataModel.EmitterShapeSphereAndDivision64Division;
            this.EmitterShapeCircleDivision = srcDataModel.EmitterShapeCircleDivision;
            this.EmitterShapeCircleDivisionRandom = srcDataModel.EmitterShapeCircleDivisionRandom;
            this.EmitterShapeLineDivision = srcDataModel.EmitterShapeLineDivision;
            this.EmitterShapeLineDivisionRandom = srcDataModel.EmitterShapeLineDivisionRandom;
            this.EmitterScaleShapeScale = srcDataModel.EmitterScaleShapeScale;
            this.PrimitiveFilePath = srcDataModel.PrimitiveFilePath;
            this.RandomPosition = srcDataModel.RandomPosition;
            this.ShapeScaleAnimation = srcDataModel.ShapeScaleAnimation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterType", this.EmitterType);
            this.WriteElement(context, "EmitterTypeEmitterRadius", this.EmitterTypeEmitterRadius);
            this.WriteElement(context, "EmitterShapeLongitudeArcLength", this.EmitterShapeLongitudeArcLength);
            this.WriteElement(context, "EmitterShapeLatitudeArcLength", this.EmitterShapeLatitudeArcLength);
            this.WriteElement(context, "EmitterShapeStartArc", this.EmitterShapeStartArc);
            this.WriteElement(context, "EmitterShapeStartArcRandom", this.EmitterShapeStartArcRandom);
            this.WriteElement(context, "EmitterShapeRandomPos", this.EmitterShapeRandomPos);
            this.WriteElement(context, "EmitterShapeHollowRatio", this.EmitterShapeHollowRatio);
            this.WriteElement(context, "EmitterShapeArcType", this.EmitterShapeArcType);
            this.WriteElement(context, "EmitterShapeLineCenter", this.EmitterShapeLineCenter);
            this.WriteElement(context, "EmitterShapeLineLength", this.EmitterShapeLineLength);
            this.WriteElement(context, "EmitterShapeEmissionType", this.EmitterShapeEmissionType);
            this.WriteElement(context, "EmitterShapeSphereAxis", this.EmitterShapeSphereAxis);
            this.WriteElement(context, "EmitterShapeSphereAndDivisionDivision", this.EmitterShapeSphereAndDivisionDivision);
            this.WriteElement(context, "EmitterShapeSphereAndDivision64Division", this.EmitterShapeSphereAndDivision64Division);
            this.WriteElement(context, "EmitterShapeCircleDivision", this.EmitterShapeCircleDivision);
            this.WriteElement(context, "EmitterShapeCircleDivisionRandom", this.EmitterShapeCircleDivisionRandom);
            this.WriteElement(context, "EmitterShapeLineDivision", this.EmitterShapeLineDivision);
            this.WriteElement(context, "EmitterShapeLineDivisionRandom", this.EmitterShapeLineDivisionRandom);
            this.WriteElement(context, "EmitterScaleShapeScale", this.EmitterScaleShapeScale);
            this.WriteElement(context, "PrimitiveFilePath", this.PrimitiveFilePath);
            this.WriteElement(context, "RandomPosition", this.RandomPosition);
            this.WriteElement(context, "ShapeScaleAnimation", this.ShapeScaleAnimation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterType = this.ReadElement(context, "EmitterType", this.EmitterType);
            this.EmitterTypeEmitterRadius = this.ReadElement(context, "EmitterTypeEmitterRadius", this.EmitterTypeEmitterRadius);
            this.EmitterShapeLongitudeArcLength = this.ReadElement(context, "EmitterShapeLongitudeArcLength", this.EmitterShapeLongitudeArcLength);
            this.EmitterShapeLatitudeArcLength = this.ReadElement(context, "EmitterShapeLatitudeArcLength", this.EmitterShapeLatitudeArcLength);
            this.EmitterShapeStartArc = this.ReadElement(context, "EmitterShapeStartArc", this.EmitterShapeStartArc);
            this.EmitterShapeStartArcRandom = this.ReadElement(context, "EmitterShapeStartArcRandom", this.EmitterShapeStartArcRandom);
            this.EmitterShapeRandomPos = this.ReadElement(context, "EmitterShapeRandomPos", this.EmitterShapeRandomPos);
            this.EmitterShapeHollowRatio = this.ReadElement(context, "EmitterShapeHollowRatio", this.EmitterShapeHollowRatio);
            this.EmitterShapeArcType = this.ReadElement(context, "EmitterShapeArcType", this.EmitterShapeArcType);
            this.EmitterShapeLineCenter = this.ReadElement(context, "EmitterShapeLineCenter", this.EmitterShapeLineCenter);
            this.EmitterShapeLineLength = this.ReadElement(context, "EmitterShapeLineLength", this.EmitterShapeLineLength);
            this.EmitterShapeEmissionType = this.ReadElement(context, "EmitterShapeEmissionType", this.EmitterShapeEmissionType);
            this.EmitterShapeSphereAxis = this.ReadElement(context, "EmitterShapeSphereAxis", this.EmitterShapeSphereAxis);
            this.EmitterShapeSphereAndDivisionDivision = this.ReadElement(context, "EmitterShapeSphereAndDivisionDivision", this.EmitterShapeSphereAndDivisionDivision);
            this.EmitterShapeSphereAndDivision64Division = this.ReadElement(context, "EmitterShapeSphereAndDivision64Division", this.EmitterShapeSphereAndDivision64Division);
            this.EmitterShapeCircleDivision = this.ReadElement(context, "EmitterShapeCircleDivision", this.EmitterShapeCircleDivision);
            this.EmitterShapeCircleDivisionRandom = this.ReadElement(context, "EmitterShapeCircleDivisionRandom", this.EmitterShapeCircleDivisionRandom);
            this.EmitterShapeLineDivision = this.ReadElement(context, "EmitterShapeLineDivision", this.EmitterShapeLineDivision);
            this.EmitterShapeLineDivisionRandom = this.ReadElement(context, "EmitterShapeLineDivisionRandom", this.EmitterShapeLineDivisionRandom);
            this.EmitterScaleShapeScale = this.ReadElement(context, "EmitterScaleShapeScale", this.EmitterScaleShapeScale);
            this.PrimitiveFilePath = this.ReadElement(context, "PrimitiveFilePath", this.PrimitiveFilePath);
            this.RandomPosition = this.ReadElement(context, "RandomPosition", this.RandomPosition);
            this.ShapeScaleAnimation = this.ReadElement(context, "ShapeScaleAnimation", this.ShapeScaleAnimation);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterEmitterShapeData(PrevVersion.EmitterEmitterShapeData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterEmitterShapeData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterEmitterShapeData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterType = srcDataModel.EmitterType;
            this.EmitterTypeEmitterRadius = srcDataModel.EmitterTypeEmitterRadius;
            this.EmitterShapeLongitudeArcLength = srcDataModel.EmitterShapeLongitudeArcLength;
            this.EmitterShapeLatitudeArcLength = srcDataModel.EmitterShapeLatitudeArcLength;
            this.EmitterShapeStartArc = srcDataModel.EmitterShapeStartArc;
            this.EmitterShapeStartArcRandom = srcDataModel.EmitterShapeStartArcRandom;
            this.EmitterShapeRandomPos = srcDataModel.EmitterShapeRandomPos;
            this.EmitterShapeHollowRatio = srcDataModel.EmitterShapeHollowRatio;
            this.EmitterShapeArcType = srcDataModel.EmitterShapeArcType;
            this.EmitterShapeLineCenter = srcDataModel.EmitterShapeLineCenter;
            this.EmitterShapeLineLength = srcDataModel.EmitterShapeLineLength;
            this.EmitterShapeEmissionType = srcDataModel.EmitterShapeEmissionType;
            this.EmitterShapeSphereAxis = srcDataModel.EmitterShapeSphereAxis;
            this.EmitterShapeSphereAndDivisionDivision = srcDataModel.EmitterShapeSphereAndDivisionDivision;
            this.EmitterShapeSphereAndDivision64Division = srcDataModel.EmitterShapeSphereAndDivision64Division;
            this.EmitterShapeCircleDivision = srcDataModel.EmitterShapeCircleDivision;
            this.EmitterShapeCircleDivisionRandom = srcDataModel.EmitterShapeCircleDivisionRandom;
            this.EmitterShapeLineDivision = srcDataModel.EmitterShapeLineDivision;
            this.EmitterShapeLineDivisionRandom = srcDataModel.EmitterShapeLineDivisionRandom;
            this.EmitterScaleShapeScale = srcDataModel.EmitterScaleShapeScale;
            this.PrimitiveFilePath = srcDataModel.PrimitiveFilePath;
            this.RandomPosition = srcDataModel.RandomPosition;
            this.ShapeScaleAnimation = srcDataModel.ShapeScaleAnimation;

            return true;
        }
    }
}
