﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// プレビューをワークスペースごと保存する際のシリアライズ用データです。
    /// </summary>
    [Serializable]
    public class PreviewInstanceData : DataModelBase
    {
        /// <summary>
        /// プレビューデータです。
        /// </summary>
        private PreviewData previewData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public PreviewInstanceData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// プレビュー名です。
        /// </summary>
        [DataModelPropertyGuid("11eb50ab-9295-4ec7-a986-94de4cd4664a")]
        public string Name { get; set; }

        /// <summary>
        /// プレビューデータです。
        /// </summary>
        [DataModelPropertyGuid("9aaf9dad-4a18-4b0c-a5d6-60dba852f99a")]
        public PreviewData PreviewData
        {
            get { return this.GetDataModelFromField(ref this.previewData, false); }
            set { this.SetDataModelToField(ref this.previewData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.PreviewInstanceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.PreviewData = srcDataModel.PreviewData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Name", this.Name);
            this.WriteElement(context, "PreviewData", this.PreviewData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Name = this.ReadElement(context, "Name", this.Name);
            this.PreviewData = this.ReadElement(context, "PreviewData", this.PreviewData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.PreviewInstanceData(PrevVersion.PreviewInstanceData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.PreviewInstanceData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.PreviewInstanceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.Name = srcDataModel.Name;
            this.PreviewData = srcDataModel.PreviewData;

            return true;
        }
    }
}
