﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/カメラタブです。
    /// </summary>
    [Serializable]
    public class ViewerCameraData : DataModelBase
    {
        /// <summary>
        /// ビュー/射影グループです.
        /// </summary>
        private ViewerCameraViewProjectionData viewProjectionData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerCameraData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// ビュー/射影グループです.
        /// </summary>
        [DataModelPropertyGuid("edc19ee1-cce1-4618-87d4-9557c3cc13aa")]
        public ViewerCameraViewProjectionData ViewProjectionData
        {
            get { return this.GetDataModelFromField(ref this.viewProjectionData, false); }
            set { this.SetDataModelToField(ref this.viewProjectionData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerCameraData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ViewProjectionData = srcDataModel.ViewProjectionData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "ViewProjectionData", this.ViewProjectionData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.ViewProjectionData = this.ReadElement(context, "ViewProjectionData", this.ViewProjectionData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.ViewerCameraData(PrevVersion.ViewerCameraData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.ViewerCameraData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.ViewerCameraData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.ViewProjectionData = srcDataModel.ViewProjectionData;

            return true;
        }
    }
}
