﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using PrevVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_0;
using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_1_0_0_1;

namespace EffectMaker.DataModel.Specific.DataModels.Version_1_0_0_1
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// エミッタノード/カラータブ/パーティクルサブタブデータです。
    /// </summary>
    [Serializable]
    public class EmitterColorData : DataModelBase
    {
        /// <summary>
        /// カラー計算グループデータを取得または設定します。
        /// </summary>
        private EmitterColorCalculationData emitterColorCalculationData = null;

        /// <summary>
        /// カラー・アルファ設定グループデータを取得または設定します。
        /// </summary>
        private EmitterColorSettingsData emitterColorSettingsData = null;

        /// <summary>
        /// アルファ処理グループデータを取得または設定します。
        /// </summary>
        private EmitterColorAlphaProcessingData emitterColorAlphaProcessData = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterColorData() :
            base()
        {

            this.PostConstruct();
        }

        /// <summary>
        /// カラー計算グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("47777185-8186-43e6-87f7-0d5fd2745b47")]
        public EmitterColorCalculationData EmitterColorCalculationData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorCalculationData, false); }
            set { this.SetDataModelToField(ref this.emitterColorCalculationData, value); }
        }

        /// <summary>
        /// カラー・アルファ設定グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("111ccdd5-c0fa-49bb-918e-2754ef632820")]
        public EmitterColorSettingsData EmitterColorSettingsData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorSettingsData, false); }
            set { this.SetDataModelToField(ref this.emitterColorSettingsData, value); }
        }

        /// <summary>
        /// アルファ処理グループデータを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("2c1dda04-fb77-4c6a-949f-77476e6a537d")]
        public EmitterColorAlphaProcessingData EmitterColorAlphaProcessData
        {
            get { return this.GetDataModelFromField(ref this.emitterColorAlphaProcessData, false); }
            set { this.SetDataModelToField(ref this.emitterColorAlphaProcessData, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.EmitterColorCalculationData = srcDataModel.EmitterColorCalculationData;
            this.EmitterColorSettingsData = srcDataModel.EmitterColorSettingsData;
            this.EmitterColorAlphaProcessData = srcDataModel.EmitterColorAlphaProcessData;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "EmitterColorCalculationData", this.EmitterColorCalculationData);
            this.WriteElement(context, "EmitterColorSettingsData", this.EmitterColorSettingsData);
            this.WriteElement(context, "EmitterColorAlphaProcessData", this.EmitterColorAlphaProcessData);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.EmitterColorCalculationData = this.ReadElement(context, "EmitterColorCalculationData", this.EmitterColorCalculationData);
            this.EmitterColorSettingsData = this.ReadElement(context, "EmitterColorSettingsData", this.EmitterColorSettingsData);
            this.EmitterColorAlphaProcessData = this.ReadElement(context, "EmitterColorAlphaProcessData", this.EmitterColorAlphaProcessData);

            return success;
        }

        /// <summary>
        /// Implicitly converts the data model from the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>The current version data model.</returns>
        public static implicit operator CurrVersion.EmitterColorData(PrevVersion.EmitterColorData src)
        {
            if (src == null)
            {
                return null;
            }

            var dst = new CurrVersion.EmitterColorData();
            dst.ConvertFromPreviousVersion(src);
            return dst;
        }

        /// <summary>
        /// Convert from the data model of the previous version.
        /// </summary>
        /// <param name="src">The data model of the previous version.</param>
        /// <returns>True on success.</returns>
        public override bool ConvertFromPreviousVersion(DataModelBase src)
        {
            var srcDataModel = src as PrevVersion.EmitterColorData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.ConvertFromPreviousVersion(src) == false)
            {
                return false;
            }

            this.EmitterColorCalculationData = srcDataModel.EmitterColorCalculationData;
            this.EmitterColorSettingsData = srcDataModel.EmitterColorSettingsData;
            this.EmitterColorAlphaProcessData = srcDataModel.EmitterColorAlphaProcessData;

            return true;
        }
    }
}
