﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ビューアノード/基本設定タブ/シーングループです。
    /// </summary>
    [Serializable]
    public class ViewerBasicSceneData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ViewerBasicSceneData() :
            base()
        {
            this.FrameRate = 1.0f;
            this.IsLinearMode = false;
            this.GridType = 0;

            this.PostConstruct();
        }

        /// <summary>
        /// フレームレートを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("884bf906-1450-4e8d-8810-9cf8527e63c4")]
        public float FrameRate { get; set; }

        /// <summary>
        /// リニアモードです。
        /// </summary>
        [DataModelPropertyGuid("34362ed2-2d30-4c07-a9ef-254d0e34ef9d")]
        public bool IsLinearMode { get; set; }

        /// <summary>
        /// グリッドタイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("89944c6f-9ab7-4943-adc4-24b9f8443096")]
        public int GridType { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ViewerBasicSceneData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.FrameRate = srcDataModel.FrameRate;
            this.IsLinearMode = srcDataModel.IsLinearMode;
            this.GridType = srcDataModel.GridType;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "FrameRate", this.FrameRate);
            this.WriteElement(context, "IsLinearMode", this.IsLinearMode);
            this.WriteElement(context, "GridType", this.GridType);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.FrameRate = this.ReadElement(context, "FrameRate", this.FrameRate);
            this.IsLinearMode = this.ReadElement(context, "IsLinearMode", this.IsLinearMode);
            this.GridType = this.ReadElement(context, "GridType", this.GridType);

            return success;
        }
    }
}
