﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Collections.Generic;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// カスタムシェーダータブデータです.
    /// </summary>
    [Serializable]
    public class EmitterCustomShaderData : DataModelBase
    {
        /// <summary>
        /// Get or set the custom shader user data list.
        /// </summary>
        private ArrayCollection<EmitterCustomShaderSettingData> settings = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EmitterCustomShaderData() :
            base()
        {
            this.SelectedSettingIndex = -1;

            this.PostConstruct();
        }

        /// <summary>
        /// 選択中セッティングインデックスです
        /// </summary>
        [DataModelPropertyGuid("dffbc501-1945-4ec1-80af-dff999e7896e")]
        public int SelectedSettingIndex { get; set; }

        /// <summary>
        /// Get or set the selected custom shader settings data.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("ee0ac50f-ec8d-4a96-aa25-7c3db40e6e3a")]
        public EmitterCustomShaderSettingData SelectedSettingData
        {
            get
            {
                if (this.SelectedSettingIndex < 0 || this.SelectedSettingIndex > this.Settings.Count)
                {
                    return null;
                }

                return this.Settings[this.SelectedSettingIndex];
            }
        }

        /// <summary>
        /// Get the custom shader flags of the selected settings.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("7264c5d7-2884-4d64-bffe-cd32b4bffdbe")]
        public ulong SelectedSettingFlags
        {
            get
            {
                var selectedData = this.SelectedSettingData;
                if (selectedData == null)
                {
                    return 0;
                }

                return selectedData.Flags;
            }
        }

        /// <summary>
        /// Get or set the custom shader user data list.
        /// </summary>
        [DataModelPropertyGuid("d0ef4798-80b8-425c-b0ff-82e56351c5eb")]
        public ArrayCollection<EmitterCustomShaderSettingData> Settings
        {
            get
            {
                return this.GetDataModelArrayCollectionFromField(8, ref this.settings);
            }

            set
            {
                this.SetDataModelArrayCollectionToField(8, ref this.settings, value);
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EmitterCustomShaderData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SelectedSettingIndex = srcDataModel.SelectedSettingIndex;
            this.Settings = srcDataModel.Settings;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "SelectedSettingIndex", this.SelectedSettingIndex);
            this.WriteElement(context, "Settings", this.Settings);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.SelectedSettingIndex = this.ReadElement(context, "SelectedSettingIndex", this.SelectedSettingIndex);
            this.Settings = this.ReadElement(context, "Settings", this.Settings);

            return success;
        }
    }
}
