﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Serializer;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels.Version_0_0_0_0;

namespace EffectMaker.DataModel.Specific.Serializer.Version_0_0_0_0
{
    /// <summary>
    /// Data model serializer at the current version.
    /// </summary>
    public class DataModelSerializer : DataModelSerializerBase
    {
        /// <summary>The version of the data model serializer.</summary>
        private static readonly Version SerializerVersion =
            new Version("0.0.0.0");

        /// <summary>The extra types of the current version.</summary>
        private static readonly Type[] ExtraTypes = new Type[]
        {
            typeof(CurrVersion.RandomData),
            typeof(CurrVersion.RandomFe1Data),
            typeof(CurrVersion.MagnetData),
            typeof(CurrVersion.SpinData),
            typeof(CurrVersion.ConvergeData),
            typeof(CurrVersion.AddLocationData),
            typeof(CurrVersion.CollisionData),
            typeof(CurrVersion.CurlNoiseData),
            typeof(CurrVersion.StripeComplexData),
            typeof(CurrVersion.StripeHistoryData),
        };

        /// <summary>Maps the data model type of the previous to the current version.</summary>
        private static readonly Dictionary<Type, Type> VersionTypeMap = new Dictionary<Type, Type>();

        /// <summary>Maps the data model type of the current to the previous version.</summary>
        private static readonly Dictionary<Type, Type> InverseVersionTypeMap = new Dictionary<Type, Type>();

        /// <summary>
        /// Static constructor.
        /// </summary>
        static DataModelSerializer()
        {
            Instance = new DataModelSerializer();
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        private DataModelSerializer()
        {
        }

        /// <summary>
        /// Get the singleton instance for the serializer.
        /// </summary>
        public static DataModelSerializer Instance { get; private set; }

        /// <summary>
        /// Get the version of the data model serializer.
        /// </summary>
        public override Version Version
        {
            get { return SerializerVersion; }
        }

        /// <summary>
        /// Enumerate the extra data model types for serialization.
        /// </summary>
        public override IEnumerable<Type> ExtraDataModelTypes
        {
            get { return ExtraTypes; }
        }

        /// <summary>
        /// Get the dictionary that maps the data model types
        /// from the previous to the current version.
        /// </summary>
        protected override Dictionary<Type, Type> TypeMap
        {
            get { return VersionTypeMap; }
        }

        /// <summary>
        /// Get the dictionary that maps the data model types
        /// from the current to the previous version.
        /// </summary>
        protected override Dictionary<Type, Type> InverseTypeMap
        {
            get { return InverseVersionTypeMap; }
        }
    }
}
