﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Manager;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for an array of textures.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class TextureArrayData : DataModelBase
    {
        /// <summary>The list of texture resource data.</summary>
        private List<TextureResourceData> textureResourceList = new List<TextureResourceData>();

        /// <summary>The list of texture binary data.</summary>
        private List<TextureBinaryData> textureBinaryList = new List<TextureBinaryData>();

        /// <summary>
        /// Constructor.
        /// </summary>
        public TextureArrayData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the list of texture resource data.
        /// </summary>
        public IEnumerable<TextureResourceData> TextureResources
        {
            get { return this.textureResourceList; }
        }

        /// <summary>
        /// Get or set the list of texture binary data.
        /// </summary>
        public IEnumerable<TextureBinaryData> TextureBinaries
        {
            get { return this.textureBinaryList; }
        }

        /// <summary>
        /// Add a new texture path to the texture array, the corresponding
        /// texture resource data and texture binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="path">The texture path.</param>
        /// <param name="typeTag">テクスチャテクスチャファイル形式を表すタグ</param>
        public void AddTexturePath(string path, string typeTag)
        {
            var textureRes = new TextureResourceData()
            {
                Parent = this,
                TexturePath = path
            };

            var textureBin = new TextureBinaryData()
            {
                Parent = this,
                TexturePath = path,
                TextureTypeTag = typeTag,
            };

            this.textureResourceList.Add(textureRes);
            this.textureBinaryList.Add(textureBin);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as TextureArrayData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.SetDataModelListToField(
                ref this.textureResourceList,
                srcDataModel.textureResourceList);

            this.SetDataModelListToField(
                ref this.textureBinaryList,
                srcDataModel.textureBinaryList);

            return true;
        }
    }
}
