﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.DataModel.DataModels;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for custom shader resource information.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class CustomShaderResourceData : ShaderResourceData
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public CustomShaderResourceData() :
            base()
        {
        }

        /// <summary>
        /// Get or set the shader ID.
        /// </summary>
        public int ShaderID { get; set; }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CustomShaderResourceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.ShaderID = srcDataModel.ShaderID;

            return true;
        }
    }
}
