﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel.DataModels;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// トリミングプリミティブの情報です。
    /// このデータモデルはバイナリ出力用に使います。
    /// </summary>
    public class TrimmingPrimitiveResourceData : DataModelBase
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public TrimmingPrimitiveResourceData()
        {
        }

        /// <summary>
        /// テクスチャパスを取得または設定します。
        /// </summary>
        public string TexturePath { get; set; }

        /// <summary>
        /// データをセットします。
        /// </summary>
        /// <param name="src">コピー元のオブジェクト</param>
        /// <returns>成功したときはtrueを返します。.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as TrimmingPrimitiveResourceData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.TexturePath = srcDataModel.TexturePath;

            return true;
        }
    }
}
