﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using EffectMaker.DataModel.DataModels;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// Data model for an array of g3d primitive.
    /// This data model is made for writing binary data.
    /// </summary>
    /// <remarks>
    /// This data model is not generated from the DataModelMaker, do not overwrite it.
    /// </remarks>
    public class G3dPrimitiveArrayData : DataModelBase
    {
        /// <summary>
        /// プリミティブファイルパスリストです。
        /// </summary>
        private List<string> primitivePaths = new List<string>();

        /// <summary>
        /// プリミティブテーブルデータです。
        /// </summary>
        private G3dPrimitiveTableData tableData = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public G3dPrimitiveArrayData() : base()
        {
        }

        /// <summary>
        /// プリミティブファイルパスリストを取得します。
        /// </summary>
        public IEnumerable<string> PrimitivePaths
        {
            get { return this.primitivePaths; }
        }

        /// <summary>
        /// プリミティブテーブルデータモデルを取得します。
        /// </summary>
        public G3dPrimitiveTableData TableData
        {
            get { return this.tableData ?? (this.tableData = new G3dPrimitiveTableData(this)); }
        }

        /// <summary>
        /// Add a new primitive path to the primitive array, the corresponding
        /// primitive resource data and primitive binary data will be automatically
        /// created.
        /// </summary>
        /// <param name="path">The texture path.</param>
        public void AddPrimitivePath(string path)
        {
            this.primitivePaths.Add(path);
        }

        /// <summary>
        /// Set up the data model with the given source object.
        /// </summary>
        /// <param name="src">The source object to set from.</param>
        /// <returns>True on success.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as G3dPrimitiveArrayData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.primitivePaths = new List<string>(srcDataModel.primitivePaths);

            return true;
        }
    }
}
