﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterSetUserValueData.
    /// </summary>
    public class EmitterSetUserValueViewModel : PropertyGroupViewModel<EmitterSetUserValueData>, IModificationFlagOwner
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterSetUserValueViewModel(HierarchyViewModel parent, EmitterSetUserValueData dataModel)
            : base(parent, dataModel)
        {
            // Always create the modification flag view model IN THE END of the constructor
            // to prevent any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// 数値1のラベルを取得します.
        /// </summary>
        public string Value1Label
        {
            get
            {
                var setting = OptionStore.ProjectConfig.EmitterSetUserDataSetting;

                if (setting.IntNumberLabel.Count >= 1)
                {
                    return setting.IntNumberLabel[0];
                }
                else
                {
                    return Properties.Resources.EmitterSetUserValueValue1;
                }
            }
        }

        /// <summary>
        /// 数値2のラベルを取得します.
        /// </summary>
        public string Value2Label
        {
            get
            {
                var setting = OptionStore.ProjectConfig.EmitterSetUserDataSetting;

                if (setting.IntNumberLabel.Count >= 2)
                {
                    return setting.IntNumberLabel[1];
                }
                else
                {
                    return Properties.Resources.EmitterSetUserValueValue2;
                }
            }
        }

        /// <summary>
        /// 数値3のラベルを取得します.
        /// </summary>
        public string Value3Label
        {
            get
            {
                var setting = OptionStore.ProjectConfig.EmitterSetUserDataSetting;

                if (setting.IntNumberLabel.Count >= 3)
                {
                    return setting.IntNumberLabel[2];
                }
                else
                {
                    return Properties.Resources.EmitterSetUserValueValue3;
                }
            }
        }

        /// <summary>
        /// 数値4のラベルを取得します.
        /// </summary>
        public string Value4Label
        {
            get
            {
                var setting = OptionStore.ProjectConfig.EmitterSetUserDataSetting;

                if (setting.IntNumberLabel.Count >= 4)
                {
                    return setting.IntNumberLabel[3];
                }
                else
                {
                    return Properties.Resources.EmitterSetUserValueValue4;
                }
            }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel { get; private set; }

        /// <summary>
        /// オプションを変更したときの処理を行います.
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The event arguments.</param>
        protected override void OnOptionChanged(object sender, EventArgs e)
        {
            base.OnOptionChanged(sender, e);
            this.OnPropertyChanged(() => this.Value1Label);
            this.OnPropertyChanged(() => this.Value2Label);
            this.OnPropertyChanged(() => this.Value3Label);
            this.OnPropertyChanged(() => this.Value4Label);
        }
    }
}
