﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.ObjectModel;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.UILogic.ViewModels
{
    /// <summary>
    /// Class for the view model of the EmitterExtParams.
    /// </summary>
    [Tag("WorkspaceNodeViewModelKind")]
    public class EmitterExtParamsViewModel : WorkspaceNodeViewModelBase<EmitterExtParams>, IModificationFlagOwner
    {
        /// <summary>The property page view model for this node.</summary>
        private EmitterExtParamsUserDataViewModel propertyPageViewModel;

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="parent">The parent view model.</param>
        /// <param name="dataModel">The data model to encapsulate.</param>
        public EmitterExtParamsViewModel(HierarchyViewModel parent, EmitterExtParams dataModel)
            : base(parent, dataModel)
        {
            // エミッタ拡張パラメータ.
            this.propertyPageViewModel = new EmitterExtParamsUserDataViewModel(this, dataModel);
            this.Children.Add(this.propertyPageViewModel);

            // Always create the modification flag view model IN THE END of the constructor,
            // in case any initialization triggers the modification events.
            this.ModificationFlagViewModel = new ModificationFlagViewModel(this);
        }

        /// <summary>
        /// エミッタ拡張パラメータ名を取得します.
        /// </summary>
        public string Name
        {
            get { return Properties.Resources.EmitterExtParamsNodeName; }
        }

        /// <summary>
        /// Get the view model that holds the modification flags of
        /// this view model's properties.
        /// </summary>
        public ModificationFlagViewModel ModificationFlagViewModel
        {
            get;
            private set;
        }

        /// <summary>
        /// The default property page view model to use
        /// on the first time the workspace node is selected.
        /// </summary>
        public override HierarchyViewModel DefaultPropertyPageViewModel
        {
            get { return this.propertyPageViewModel; }
        }

        /// <summary>
        /// Get the selected item.
        /// </summary>
        public HierarchyViewModel SelectedItem { get; set; }
    }
}
