﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Model;
using EffectMaker.Foundation.Model.Types;

namespace EffectMaker.PrimitiveManager.Loader
{
    /// <summary>
    /// モデルローダインターフェース
    /// </summary>
    public interface IModelLoader
    {
        /// <summary>
        /// ファイルが読み込めるか調査する
        /// </summary>
        /// <param name="filePath">調査するファイルパス</param>
        /// <returns>読み込めるかどうか？</returns>
        bool CanLoad(string filePath);

        /// <summary>
        /// ロードする
        /// </summary>
        /// <param name="filePath">ロードするファイルパス</param>
        /// <param name="modelData">ロードしたモデルデータ</param>
        /// <returns>結果</returns>
        LoadModelResults Load(string filePath, out ModelData modelData);

        /// <summary>
        /// コメント情報だけを読み込みます。
        /// </summary>
        /// <param name="filePath">ファイルパス</param>
        /// <param name="comment">[out]コメント</param>
        /// <param name="color">[out]ラベルカラー</param>
        /// <returns>成功したらtrue,失敗したらfalse.</returns>
        bool LoadComment(string filePath, out string comment, out string color);
    }
}
