﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.CodeDom;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.BusinessLogic.UserData;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Extensions;

namespace EffectMaker.DataModelLogic.DataModelProxies
{
    /// <summary>
    /// Data model proxy for model data.
    /// </summary>
    public class ModelDataProxy : DataModelProxy
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="dataModel">The data model for the proxy.</param>
        public ModelDataProxy(DataModelBase dataModel) :
            base(dataModel)
        {
            this.UpdateUserData();
        }

        /// <summary>
        /// Update user data models.
        /// </summary>
        public void UpdateUserData()
        {
            var modelData = this.DataModel as ModelData;
            Debug.Assert(modelData != null, "ModelDataじゃない");

            // Create user data models.
            IEnumerable<UserDataBase> userDataModels =
                UserDataManager.CreateUserDataForOwner(typeof(ModelData));

            var userPages = modelData.UserPages.ToArray();

            // モデルのユーザーデータページ再生成が必要かをチェック
            bool needRebuild = true;
            if (userPages.Length == userDataModels.Count())
            {
                int i = 0;
                foreach (var userDataModel in userDataModels)
                {
                    if (userDataModel.GetType() != userPages[i].GetType())
                    {
                        break;
                    }

                    ++i;
                }

                needRebuild = false;
            }

            if (needRebuild)
            {
                // First clear all the user pages.
                modelData.UserPages.Clear();
                userPages.ForEach(p => modelData.Children.Remove(p));

                // Create one user page data for each of the user data model.
                var createdUserPages = userDataModels.Select(
                    dm => new UserPageData() { ContentsData = dm });

                // Add these created user pages.
                foreach (UserPageData pageData in createdUserPages)
                {
                    modelData.UserPages.Add(pageData);
                    modelData.AddChild(pageData);
                }
            }

            // Fire event.
            this.TriggerPropertyModifiedEvent("UserPages");
        }
    }
}
