﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.DataModelLogic.BinaryData
{
    /// <summary>
    /// Class for the definition of an binary data field that stores the size
    /// of another binary structure.
    /// </summary>
    public class BinaryStructSizeFieldDefinition : BinaryFieldDefinition
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="adjustValue">The value to add to the final size value of the field.</param>
        /// <param name="sendModificationType">The type of message to send if data is modified.</param>
        /// <param name="converterDef">The converter definition.</param>
        /// <param name="structDef">The definition of a binary structure for the field.</param>
        /// <param name="inputProperties">The array of definition of the input properties.</param>
        public BinaryStructSizeFieldDefinition(
            int adjustValue,
            SendModificationTypes sendModificationType,
            ConverterDefinition converterDef,
            BinaryStructDefinition structDef,
            params InputPropertyDefinition[] inputProperties) :
            base(sendModificationType, converterDef, structDef, inputProperties)
        {
            this.AdjustValue = adjustValue;
        }

        /// <summary>
        /// Get the value to add to the final size value of the field.
        /// </summary>
        public int AdjustValue { get; private set; }

        /// <summary>
        /// Create an instance with the definition.
        /// </summary>
        /// <param name="parent">The parent binary data structure instance.</param>
        /// <returns>The created instance.</returns>
        public override BinaryFieldInstance CreateInstance(BinaryStructInstance parent)
        {
            return new BinaryStructSizeFieldInstance(parent, this);
        }
    }
}
