﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

using EffectMaker.DataModel.Attributes;

namespace EffectMaker.DataModelLogic.BinaryConverters
{
    /// <summary>
    /// Class for the default field converter that passes value directly to output.
    /// </summary>
    public class AdditionConverter : ConverterBase
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        public AdditionConverter() :
            base(null)
        {
        }

        /// <summary>
        /// Get the number of input values.
        /// </summary>
        public override int MaxInputValueCount
        {
            get { return 2; }
        }

        /// <summary>
        /// Get the description of the converter.
        /// </summary>
        public override string Description
        {
            get { return Properties.Resources.AdditionConverterDesc; }
        }

        /// <summary>
        /// Get the output value description.
        /// </summary>
        public override string OutputValueDescription
        {
            get { return Properties.Resources.AdditionConverterOutputValueDesc; }
        }

        /// <summary>
        /// Get the description of the input value.
        /// </summary>
        /// <param name="index">The index to the input value.</param>
        /// <returns>The description.</returns>
        public override string GetInputValueDescription(int index)
        {
            if (index == 0)
            {
                return Properties.Resources.AdditionConverterInputValue0Desc;
            }
            else if (index == 1)
            {
                return Properties.Resources.AdditionConverterInputValue1Desc;
            }
            else
            {
                return Properties.Resources.WarningInvalidConverterInputValueIndex;
            }
        }

        /// <summary>
        /// Convert data model field values.
        /// </summary>
        /// <returns>True on success.</returns>
        public override bool Convert()
        {
            object inputValue1 = this.GetInputValue(0);
            object inputValue2 = this.GetInputValue(1);

            Type valueType = inputValue1.GetType();
            if (valueType == inputValue2.GetType() == false)
            {
                return false;
            }

            if (inputValue1 is int)
            {
                int result = (int)inputValue1 + (int)inputValue2;
                this.SetOutputValue(result);
            }
            else if (inputValue1 is uint)
            {
                uint result = (uint)inputValue1 + (uint)inputValue2;
                this.SetOutputValue(result);
            }
            else if (inputValue1 is long)
            {
                long result = (long)inputValue1 + (long)inputValue2;
                this.SetOutputValue(result);
            }
            else if (inputValue1 is ulong)
            {
                ulong result = (ulong)inputValue1 + (ulong)inputValue2;
                this.SetOutputValue(result);
            }
            else if (inputValue1 is float)
            {
                float result = (float)inputValue1 + (float)inputValue2;
                this.SetOutputValue(result);
            }
            else if (inputValue1 is double)
            {
                double result = (double)inputValue1 + (double)inputValue2;
                this.SetOutputValue(result);
            }
            else
            {
                return false;
            }

            return true;
        }
    }
}
