﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.BusinessLogic.UserData
{
    /// <summary>
    /// USD, UDDファイルコンバータのインターフェイスです。
    /// </summary>
    public interface IObsoleteUserDataConverter
    {
        /// <summary>
        /// USDファイルを新形式にコンバートします。
        /// </summary>
        /// <param name="usdFilePath">USDファイルパス</param>
        /// <param name="dataModelName">出力するデータモデルの名前</param>
        /// <returns>コンバートが成功したときtrueを返します。</returns>
        bool ConvertUsd(string usdFilePath, string dataModelName, string outputFolderPath, string language);

        /// <summary>
        /// UDDファイルを新形式にコンバートします。
        /// </summary>
        /// <param name="uddFilePath">UDDファイルパス</param>
        /// <param name="dataModelName">出力するデータモデルの名前</param>
        /// <returns>コンバートが成功したときtrueを返します。</returns>
        bool ConvertUdd(string uddFilePath, string dataModelName, string outputFolderPath, string language);
    }
}
