﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace EffectMaker.BusinessLogic.Protocol
{
    /// <summary>
    /// プラットフォームタイプです.
    /// </summary>
    public enum PlatformType : int
    {
        /// <summary>Platform:Windows Little Endian(=0x0000(Win Viewer, Little Endian) + 0x0000)</summary>
        Windows = 0x0000,

        /// <summary>Platform:Cafe Big Endian(=0x1100(実機、Big Endian) + 0x0001)</summary>
        Cafe = 0x1101,

        /// <summary>Platform:CTR Little Endian(=0x1000(実機、Little Endian) + 0x0002)</summary>
        CTR = 0x1002,

        /// <summary>Platform:CTR Little Endian(=0x1000(実機、Little Endian) + 0x0002)</summary>
        HTC = 0x1003,

        /// <summary>エンディアン用マスク</summary>
        EndianMask = 0x0F00,

        /// <summary>実機(Use Native Format)用マスク</summary>
        NativeFormatMask = 0xF000,
    }
}
