﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.DataModel;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.BusinessLogic.DataModelOperation
{
    /// <summary>
    /// Class for create a data model.
    /// </summary>
    public class DataModelCreator
    {
        /// <summary>
        /// エミッタセットのデータモデルを作成します.
        /// </summary>
        /// <returns>エミッタセットのデータモデルを返します.</returns>
        public static EmitterSetData CreateEmitterSetDataModel()
        {
            return new EmitterSetData();
        }

        /// <summary>
        /// エミッタのデータモデルを作成します.
        /// </summary>
        /// <returns>エミッタのデータモデルを返します.</returns>
        public static EmitterData CreateEmitterDataModel()
        {
            return new EmitterData();
        }

        /// <summary>
        /// フィールドのデータモデルを作成します.
        /// </summary>
        /// <param name="fieldType">フィールドのタイプ.</param>
        /// <returns>フィールドのデータモデルを返します.</returns>
        public static FieldDataBase CreateFieldDataModel(FieldTypes fieldType)
        {
            switch (fieldType)
            {
                case FieldTypes.AddLocation:
                    return new AddLocationData();
                case FieldTypes.Collision:
                    return new CollisionData();
                case FieldTypes.Converge:
                    return new ConvergeData();
                case FieldTypes.CurlNoise:
                    return new CurlNoiseData();
                case FieldTypes.Magnet:
                    return new MagnetData();
                case FieldTypes.Random:
                    return new RandomData();
                case FieldTypes.RandomFe1:
                    return new RandomFe1Data();
                case FieldTypes.Spin:
                    return new SpinData();
                case FieldTypes.CustomField:
                    return new CustomFieldData();
            }

            return null;
        }

        /// <summary>
        /// プレビューのデータモデルを作成します.
        /// </summary>
        /// <returns>プレビューのデータモデルを返します.</returns>
        public static PreviewData CreatePreviewDataModel()
        {
            return new PreviewData();
        }
    }
}
