﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;

using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;

namespace EffectMaker.BusinessLogic.BinaryResourceWriters
{
    /// <summary>
    /// Binary resource writer interface.
    /// </summary>
    public interface IBinaryResourceWriter
    {
        /// <summary>
        /// Get the data model the writer is writing.
        /// </summary>
        DataModelBase DataModel { get; }

        /// <summary>
        /// Get the position of the written data in the stream.
        /// </summary>
        long Position { get; }

        /// <summary>
        /// Get the size of the written data.
        /// </summary>
        long Size { get; }

        /// <summary>
        /// Get the offset between the binary header and
        /// the beginning of the binary resource data.
        /// </summary>
        long Offset { get; }

        /// <summary>
        /// Write data to the stream in the given context.
        /// </summary>
        /// <param name="context">The binary resource writer context.</param>
        /// <returns>True on success.</returns>
        bool Write(BinaryResourceWriterContext context);
    }
}
