﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
#region File Description
#endregion

namespace EffectMaker.Communicator
{
    #region Using Statements
    using System;
    #endregion

    /// <summary>
    /// メッセージフィルタインタフェースです.
    /// </summary>
    public interface IMessageFilter
    {
        /// <summary>
        /// メッセージ登録時の処理です.
        /// </summary>
        /// <param name="input">入力メッセージ.</param>
        /// <returns>
        /// 出力メッセージをマネージャに登録させる場合はtrueを返します.
        /// falseの場合，マネージャは登録を行わずメッセージが処理されないようになります.
        /// </returns>
        bool OnPostMessage(Message input);
    }
}
