﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;

namespace EffectMaker.Foundation.Win32
{
    /// <summary>
    /// Class containing native Windows API functions.
    /// </summary>
    public static class Functions
    {
        /// <summary>
        /// Send a message to the application message pump.
        /// </summary>
        /// <param name="windowHandle">Handle of the window that manages the message pump.</param>
        /// <param name="message">Message to send.</param>
        /// <param name="highParam">High word parameter.</param>
        /// <param name="lowParam">Low word parameter.</param>
        /// <returns>Returns a value depending on the message sent.</returns>
        [DllImport("user32.dll")]
        public static extern int SendMessage(
            IntPtr windowHandle,
            int message,
            IntPtr highParam,
            IntPtr lowParam);

        /// <summary>
        /// Send a message to the application message pump.
        /// </summary>
        /// <param name="windowHandle">Handle of the window that manages the message pump.</param>
        /// <param name="message">Message to send.</param>
        /// <param name="highParam">High word parameter.</param>
        /// <param name="lowParam">Low word parameter.</param>
        /// <returns>Returns a value depending on the message sent.</returns>
        [DllImport("user32.dll")]
        public static extern int SendMessage(
            IntPtr windowHandle,
            int message,
            bool highParam,
            int lowParam);
    }
}
