﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.Foundation.Utility
{
    /// <summary>
    /// 間引き実行機です。
    /// </summary>
    public class ThrottleExecuter : IDisposable
    {
        /// <summary>
        /// タイマー
        /// </summary>
        private Timer timer;

        /// <summary>
        /// 処理をUIスレッドで遅延実行します。
        /// </summary>
        /// <param name="delay">遅延時間</param>
        /// <param name="action">実行内容</param>
        public void Execute(int delay, Action action)
        {
            this.ReleaseTimer();

            this.timer = new Timer
            {
                Interval = delay,
            };

            this.timer.Tick += (s, e) =>
            {
                action();
                this.ReleaseTimer();
            };

            this.timer.Start();
        }

        /// <summary>
        /// Dispose()
        /// </summary>
        public void Dispose()
        {
            this.ReleaseTimer();
        }

        /// <summary>
        /// タイマー開放
        /// </summary>
        private void ReleaseTimer()
        {
            if (this.timer != null)
            {
                this.timer.Stop();
                this.timer.Dispose();
                this.timer = null;
            }
        }
    }
}
