﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Utility
{
    /// <summary>
    /// ローカライズ関連のユーティリティです。
    /// </summary>
    public static class LocalizeUtility
    {
        /// <summary>
        /// Localizeコンバータ書式のテキストを現在の言語設定に即した値に変換します。
        /// </summary>
        /// <param name="localizeFormattedText">Xamlでの使用を想定しているLocalizeコンバータの書式</param>
        /// <returns>現在の言語設定に即した文字列</returns>
        public static string Translate(string localizeFormattedText)
        {
            var value = localizeFormattedText;
            if (value.StartsWith("{Localize "))
            {
                var culture = System.Threading.Thread.CurrentThread.CurrentUICulture;
                var cultureEnUs = System.Globalization.CultureInfo.CreateSpecificCulture("en-US");
                if (culture.Equals(cultureEnUs) == true)
                {
                    int start = value.IndexOf("EN='") + 4;
                    int length = value.IndexOf("'", start) - start;
                    return value.Substring(start, length);
                }
                else
                {
                    int start = value.IndexOf("JP='") + 4;
                    int length = value.IndexOf("'", start) - start;
                    return value.Substring(start, length);
                }
            }

            return value;
        }
    }
}
