﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;

using EffectMaker.Foundation;

namespace EffectMaker.Foundation.Render.ObjectPicking
{
    /// <summary>
    /// Data context class to hold the data while doing object picking.
    /// (e.g. mouse picking... etc.)
    /// </summary>
    public class ObjectPickContext
    {
        /// <summary>The picked objects.</summary>
        private List<IPickableObject> pickedObjects = new List<IPickableObject>();

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="p">The point to pick with.</param>
        public ObjectPickContext(PointF p)
        {
            this.PickPoint = p;
        }

        /// <summary>
        /// Get or set the picking point.
        /// </summary>
        public PointF PickPoint { get; set; }

        /// <summary>
        /// Get the list that contains the picked objects.
        /// </summary>
        public IList<IPickableObject> PickedObjects
        {
            get { return this.pickedObjects; }
        }

        /// <summary>
        /// Add a picked object to the list.
        /// </summary>
        /// <param name="obj">The picked object.</param>
        public void AddPickedObject(IPickableObject obj)
        {
            this.pickedObjects.Add(obj);
        }

        /// <summary>
        /// Clear the picked objects.
        /// </summary>
        public void ClearPickedObjects()
        {
            this.pickedObjects.Clear();
        }
    }
}
