﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Render.Layout
{
    /// <summary>
    /// Horizontal alignment for laying out.
    /// </summary>
    public enum HAlignment
    {
        /// <summary>
        /// Align to left, using the least space possible.
        /// </summary>
        Left,

        /// <summary>
        /// Align to center, using the least space possible.
        /// </summary>
        Center,

        /// <summary>
        /// Align to right, using the least space possible.
        /// </summary>
        Right,

        /// <summary>
        /// Stretch horizontally using all the available space.
        /// </summary>
        Stretch,
    }
}
