﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Primitives
{
    /// <summary>
    /// Generic class for a 2-element vector with integer values.
    /// </summary>
    public class Vector2i : Primitivei
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        public Vector2i()
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source to copy from.</param>
        public Vector2i(Primitivei src)
            : base(src)
        {
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source array.</param>
        public Vector2i(int[] src)
            : base(src)
        {
        }

        /// <summary>
        /// Setter constructor.
        /// </summary>
        /// <param name="x">The x value to set.</param>
        /// <param name="y">The y value to set.</param>
        public Vector2i(
                        int x,
                        int y) :
            base()
        {
            this.Set(x, y);
        }

        /// <summary>
        /// Get the number of value elements the primitive contains.
        /// </summary>
        public override int Count
        {
            get { return 2; }
        }

        /// <summary>
        /// Get or set the X element of the vector.
        /// </summary>
        public int X
        {
            get { return this.Values[0]; }
            set { this.Values[0] = value; }
        }

        /// <summary>
        /// Get or set the Y element of the vector.
        /// </summary>
        public int Y
        {
            get { return this.Values[1]; }
            set { this.Values[1] = value; }
        }

        /// <summary>
        /// Set value from the given values.
        /// </summary>
        /// <param name="x">The x value to set.</param>
        /// <param name="y">The y value to set.</param>
        /// <returns>True on success.</returns>
        public bool Set(
                        int x,
                        int y)
        {
            this.Values[0] = x;
            this.Values[1] = y;

            return true;
        }
    }
}
