﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;

namespace EffectMaker.Foundation.Primitives
{
    /// <summary>
    /// HSVA 成分を保持するカラーです。
    /// </summary>
    public class ColorHsva : Primitivef
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public ColorHsva()
        {
            this.SetOne();
        }

        /// <summary>
        /// Copy constructor.
        /// </summary>
        /// <param name="src">The source to copy from.</param>
        public ColorHsva(Primitivef src)
            : base(src)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="h">h 成分です。</param>
        /// <param name="s">s 成分です。</param>
        /// <param name="v">v 成分です。</param>
        /// <param name="a">a 成分です。</param>
        public ColorHsva(float h, float s, float v, float a)
        {
            this.Set(h, s, v, a);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定する HsvaColor です。</param>
        public ColorHsva(ColorHsva source)
        {
            this.Set(source);
        }

        /// <summary>
        /// Get the number of value elements the primitive contains.
        /// </summary>
        public override int Count
        {
            get { return 4; }
        }

        /// <summary>
        /// Get or set the red element of the color.
        /// </summary>
        public float H
        {
            get { return this.Values[0]; }
            set { this.Values[0] = value; }
        }

        /// <summary>
        /// Get or set the green element of the color.
        /// </summary>
        public float S
        {
            get { return this.Values[1]; }
            set { this.Values[1] = value; }
        }

        /// <summary>
        /// Get or set the blue element of the color.
        /// </summary>
        public float V
        {
            get { return this.Values[2]; }
            set { this.Values[2] = value; }
        }

        /// <summary>
        /// Get or set the alpha element of the color.
        /// </summary>
        public float A
        {
            get { return this.Values[3]; }
            set { this.Values[3] = value; }
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        /// <param name="h">h 成分です。</param>
        /// <param name="s">s 成分です。</param>
        /// <param name="v">v 成分です。</param>
        /// <param name="a">a 成分です。</param>
        public void Set(float h, float s, float v, float a)
        {
            this.H = h;
            this.S = s;
            this.V = v;
            this.A = a;
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public bool Equals(ColorHsva other)
        {
            return (this.H == other.H)
                && (this.S == other.S)
                && (this.V == other.V)
                && (this.A == other.A);
        }

        /// <summary>
        /// 等値であるかどうか比較します。
        /// </summary>
        /// <param name="other">比較対象です。</param>
        /// <returns>等値であれば true を返します。</returns>
        public override bool Equals(object other)
        {
            return this.Equals(other as ColorHsva);
        }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        /// <returns>ハッシュ値です。</returns>
        public override int GetHashCode()
        {
            return this.H.GetHashCode() ^
                   this.S.GetHashCode() ^
                   this.V.GetHashCode() ^
                   this.A.GetHashCode();
        }
    }
}
