﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.Foundation.Model.Types
{
    /// <summary>
    /// モデル読み込み結果
    /// </summary>
    public enum LoadModelResults
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success,

        /// <summary>
        /// ファイルが見つからない
        /// </summary>
        FileNotFound,

        /// <summary>
        /// 未定義のモデルタイプ
        /// </summary>
        UnknowModelType,

        /// <summary>
        /// モデル読み込みに失敗
        /// </summary>
        FailedLoadingModel,

        /// <summary>
        /// バイナリコンバートに失敗
        /// </summary>
        FailedConvertBinary,

        /// <summary>
        /// ファイルバージョンが不正
        /// </summary>
        InvalidFileVersion,
    }

    /// <summary>
    /// モデル読み込み結果のメッセージコード
    /// </summary>
    public enum LoadModelMessageCodes
    {
        /// <summary>
        /// 成功
        /// </summary>
        Success,

        /// <summary>
        /// 不正なファイルパス
        /// </summary>
        InvalidFilePath,

        /// <summary>
        /// ファイルが見つからない
        /// </summary>
        FileNotFound,

        /// <summary>
        /// ファイルを開けない
        /// </summary>
        FailedOpeningFile,

        /// <summary>
        /// モデルデータを読み込めない
        /// </summary>
        FailedLoadingModel,

        /// <summary>
        /// モデルデータがない
        /// </summary>
        FailedModelNotFound,

        /// <summary>
        /// バイナリコンバータの初期化に失敗
        /// </summary>
        FailedInitConverter,

        /// <summary>
        /// バイナリコンバータにファイルの内容を追加できない
        /// </summary>
        FailedAddingResourceFiles,

        /// <summary>
        /// G3D XSDのパスが不正
        /// </summary>
        InvalidG3DXSDBasePath,

        /// <summary>
        /// ファイルバージョンが不正
        /// </summary>
        InvalidFileVersion,

        /// <summary>
        /// リソースファイルパスの取得に失敗
        /// </summary>
        FailedCollectingResources,

        /// <summary>
        /// リソースファイルが見つからない
        /// </summary>
        ResourceFilesNotFound,

        /// <summary>
        /// BinaryConverter.errCode.SetOptions
        /// </summary>
        FailedSetupConverterOptions,

        /// <summary>
        /// BinaryConverter.errCode.CalcSize
        /// </summary>
        FailedComputingSize,

        /// <summary>
        /// BinaryConverter.errCode.MallocOutBuf
        /// </summary>
        FailedAllocOutBuffer,

        /// <summary>
        /// BinaryConverter.errCode.Convert
        /// </summary>
        FailedConvertingBinary,

        /// <summary>
        /// BinaryConverter.errCode.Bind
        /// </summary>
        FailedBinding,

        /// <summary>
        /// BinaryConverter.errCode.EndianSwap
        /// </summary>
        FailedSwappingEndian,

        /// <summary>
        /// BinaryConverter.errCode.SaveFile
        /// </summary>
        FailedSaveBinFile,

        /// <summary>
        /// 原因不明のエラー
        /// </summary>
        UnknownFailure,
    }
}
