﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// Represent a container where data can only be pushed.
    /// </summary>
    /// <typeparam name="T">Type of data to push.</typeparam>
    public interface IPushOnlyContainer<in T>
    {
        /// <summary>
        /// Add a data to the container.
        /// </summary>
        /// <param name="value">Data to add.</param>
        void Add(T value);
    }
}
