﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Interfaces
{
    /// <summary>
    /// ヒエラルキーオブジェクトのインターフェイスクラス
    /// </summary>
    public interface IHierarchyObject
    {
        /// <summary>
        /// 親
        /// </summary>
        IHierarchyObject Parent { get; }

        /// <summary>
        /// 子
        /// </summary>
        ObservableCollection<IHierarchyObject> Children { get; }
    }
}
