﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Foundation.Extensions
{
    /// <summary>
    /// Extension methods for any base object.
    /// </summary>
    public static class AnyExtensions
    {
        /// <summary>
        /// Clone the input object if it is cloneable.
        /// </summary>
        /// <param name="source">The input object.</param>
        /// <returns>Returns a clone of the input object,
        /// or the input object itself if not cloneable.</returns>
        public static object CloneIfCloneable(this object source)
        {
            if (source is ICloneable)
            {
                return ((ICloneable)source).Clone();
            }

            return source;
        }
    }
}
