﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Dynamic;

namespace EffectMaker.Foundation.Dynamic
{
    /// <summary>
    /// An empty implementation of the abstract GetMemberBinder class.
    /// </summary>
    public class EffectMakerGetMemberBinder : GetMemberBinder
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="name">The name of the related getter member.</param>
        /// <param name="shouldGetNonDynamicMember">
        /// Flag indicating whether should get non-dynamic member or not.
        /// </param>
        public EffectMakerGetMemberBinder(
            string name,
            bool shouldGetNonDynamicMember = false)
            : base(name, false)
        {
            this.ShouldGetNonDynamicMember = shouldGetNonDynamicMember;
        }

        /// <summary>
        /// Get or set the flag indicating whether should get non-dynamic member or not.
        /// </summary>
        public bool ShouldGetNonDynamicMember { get; set; }

        /// <summary>
        /// Provides a fallback getter as dynamic object.
        /// (Not implemented)
        /// </summary>
        /// <param name="target">The target dynamic object.</param>
        /// <param name="errorSuggestion">An errorSuggestion dynamic object.</param>
        /// <returns>Returns nothing, throws a NotImplementedException.</returns>
        public override DynamicMetaObject FallbackGetMember(
            DynamicMetaObject target,
            DynamicMetaObject errorSuggestion)
        {
            throw new NotImplementedException();
        }
    }
}
