﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Debugging.Profiling
{
    /// <summary>
    /// An instrumentation that does nothing.
    /// Used to seamlessly desactivate an instrumentation process.
    /// </summary>
    public class NullInstrumentation : IInstrumentation
    {
        /// <summary>
        /// Initializes the NullInstrumentation instance.
        /// </summary>
        /// <param name="unsued">Unused.</param>
        public NullInstrumentation(params object[] unsued)
        {
        }

        /// <summary>
        /// Gets the instrumentation steps.
        /// Returns an empty sequence.
        /// </summary>
        public IEnumerable<IInstrumentationStepInfo> Steps
        {
            get
            {
                yield break;
            }
        }

        /// <summary>
        /// Restarts the instrumentation.
        /// Does nothing.
        /// </summary>
        public void Restart()
        {
        }

        /// <summary>
        /// Record a step of the instrumentation.
        /// Does nothing.
        /// </summary>
        /// <param name="stepDescription">The name of the current step to record.</param>
        public void Step(string stepDescription)
        {
        }

        /// <summary>
        /// Accumulate a step for the given description.
        /// Does nothing.
        /// </summary>
        /// <param name="stepDescription">The name of the current step to record.</param>
        public void Accumulate(string stepDescription)
        {
        }

        /// <summary>
        /// Disposes the instrumentation.
        /// Does nothing.
        /// </summary>
        public void Dispose()
        {
        }
    }
}
