﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::IO;
using namespace System::Drawing;
using namespace System::Drawing::Imaging;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
using namespace nw::g3d::nw4f_3dif;

namespace TexUtils
{
public ref class TextureData
{
public:
    property texture_info_quantize_typeType QuantizeType
    {
        texture_info_quantize_typeType get()
        {
            return _QuantizeType;
        }

        void set(texture_info_quantize_typeType value)
        {
            _QuantizeType = value;
        }
    }

    property texture_info_dimensionType DimensionType
    {
        texture_info_dimensionType get()
        {
            return _DimensionType;
        }

        void set(texture_info_dimensionType value)
        {
            _DimensionType = value;
        }
    }

    property array<Byte>^ ByteImage
    {
        array<Byte>^ get()              {   return _ByteImage;  }
        void set(array<Byte>^ value)    {   _ByteImage = value; }
    }
    property array<float>^ FloatImage
    {
        array<float>^ get()             {   return _FloatImage;     }
        void set(array<float>^ value)   {   _FloatImage = value;    }
    }
    property int Width
    {
        int get()           {   return _Width;  }
        void set(int value) {   _Width = value; }
    }
    property int Height
    {
        int get()           {   return _Height;     }
        void set(int value) {   _Height = value;    }
    }
    property int Depth
    {
        int get()           {   return _Depth;  }
        void set(int value) {   _Depth = value; }
    }
    property bool IsFloat
    {
        bool get()           {   return _IsFloat;  }
        void set(bool value) {   _IsFloat = value; }
    }

private:
    texture_info_quantize_typeType  _QuantizeType;
    texture_info_dimensionType      _DimensionType;
    array<Byte>^    _ByteImage;
    array<float>^   _FloatImage;
    int             _Width;
    int             _Height;
    int             _Depth;
    bool            _IsFloat;
};

}	// namespace TexUtils
