﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// コピー元ソースコード:
// Programs\Iris\Sources\Tools\Graphics\GraphicsTools\ShaderConverter\Source\gfxTool_ReadFile.cpp

#include <fstream>
#include <algorithm>

#include <gcroot.h>

#include <nn/gfxTool/gfxTool_Util.h>

#include "gfxTool_ReadFile.h"

using System::Threading::Mutex;

namespace nn {
namespace gfxTool {

#pragma region CLI Mutex

ref class StaticMutex
{
public:
    static property Mutex^ MutexInstance
    {
        Mutex^ get()
        {
            if(c_mutex == nullptr)
            {
                c_mutex = gcnew Mutex();
            }

            return c_mutex;
        }
    }

private:
    static Mutex^ c_mutex;
};

class CliLockGuard
{
public:
    CliLockGuard( Mutex^ mutex )
    {
        m_mutex = mutex;
        m_isLocked = true;

        try
        {
            m_mutex->WaitOne();
        }
        catch( System::Exception^ )
        {
            m_isLocked = false;
        }
    }

    ~CliLockGuard()
    {
        if( m_isLocked )
        {
            m_mutex->ReleaseMutex();
            m_isLocked = false;
        }
    }

    bool IsLocked()
    {
        return m_isLocked;
    }

private:
    gcroot< Mutex^ > m_mutex;
    bool             m_isLocked;
};

#pragma endregion

bool ReadFile::Callback( void** ppOutFileData,
    size_t* pOutFileDataSize, const char* pFileName, void* pParam )
{
    CliLockGuard lock( StaticMutex::MutexInstance );
    if( lock.IsLocked() == false ) return false;

    auto pThis = static_cast< ReadFile* >( pParam );
    auto found = std::find_if( pThis->m_Files.begin(), pThis->m_Files.end(), [ pFileName ]
        ( const FileType& file ) { return file.first.compare( pFileName ) == 0; } );
    if( found != pThis->m_Files.cend() )
    {
        *ppOutFileData = &found->second[ 0 ];
        *pOutFileDataSize = found->second.size();
        return true;
    }

    std::ifstream ifs( pFileName, std::ios_base::in | std::ios_base::binary );
    if( ifs.fail() )
    {
        return false;
    }

    pThis->m_Files.emplace_back();
    pThis->m_Files.back().first = pFileName;
    pThis->m_Files.back().second = Custom< std::vector< char > >::Type(
        ( std::istreambuf_iterator< char >( ifs ) ), ( std::istreambuf_iterator< char >() ) );

    *ppOutFileData = &pThis->m_Files.back().second[ 0 ];
    *pOutFileDataSize = pThis->m_Files.back().second.size();

    return !pThis->m_Files.back().second.empty();
}

}
}
