﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderCodeListCs_H__
#define __ShaderCodeListCs_H__

namespace EffectMaker {
namespace ShaderConverterWrapper {

/// <summary>
/// C#で管理するシェーダコードです.
/// </summary>
public ref class ShaderCodeListCs
{
public:
    ShaderCodeListCs()
    {
        CustomVshSrc = gcnew array<String^>(8);
        CustomFshSrc = gcnew array<String^>(8);
        ReservedVshSrc = gcnew array<String^>(8);
        ReservedFshSrc = gcnew array<String^>(8);
    }

public:
    String         ^SpecDecSrc;
    String         ^VertexShaderSrc;
    String         ^FragShaderSrc;
    String         ^StripShaderSrc;
    String         ^ParticleGlslSrc;
    String         ^ParticleDecVshSrc;
    String         ^ParticleDecFshSrc;
    String         ^StreamOutDecVshSrc;
    String         ^StreamOutVshSrc;
    String         ^GeneralVshSrc;
    String         ^GeneralFshSrc;
    String         ^GeneralCshSrc;
    array<String^> ^CustomVshSrc;
    array<String^> ^CustomFshSrc;
    array<String^> ^ReservedVshSrc;
    array<String^> ^ReservedFshSrc;
};

}
}

#endif
