﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <types.h>
#include <stdlib.h>

#pragma warning ( push )
#pragma warning ( disable: 4302 4311 4312 )
#include "cafe/gx2/gx2Constant.h"
#include "cafe/gx2/gx2Enum.h"
#include "cafe/gx2/gx2Misc.h"
#include "cafe/gx2/gx2Shaders.h"
#include "cafe/gx2/gx2Surface.h"
#include "cafe/gx2/gx2Texture.h"
#pragma warning ( pop )

#include "cafe/gfd.h"
#include "gfdMem.h"

#define MEMCPY(sdata, size, num, ddata) \
    memcpy(ddata, sdata, (size * num)); \
    ddata += size * num; \

char *GFD_API GFDWriteMemHeader(char *fp, GFDGPUVersion gpuVer)
{
    GFDHeader  header;
    memset(&header, 0, sizeof(header));
    header.magic         = GFD_SWAP_8_IN_32(GFD_HEADER_MAGIC);
    header.size          = GFD_HEADER_SIZE;
    header.majorVersion  = GFD_HEADER_MAJOR;
    header.minorVersion  = GFD_HEADER_MINOR;
    header.gpuVersion    = gpuVer;

    return GFDWriteMemPPCData(fp, (GFD_HEADER_SIZE + 3) / 4, GFD_ELEMENT_SIZE_32, (u32 *) &header);
}

char *GFD_API GFDWriteMemBlockHeader(char *fp, GFDBlockType type, u32 size)
{
    GFDBlockHeader  blockHeader;
    memset(&blockHeader, 0, sizeof(blockHeader));
    blockHeader.magic        = GFD_SWAP_8_IN_32(GFD_BLOCK_HEADER_MAGIC);
    blockHeader.size         = GFD_BLOCK_HEADER_SIZE;
    blockHeader.type         = type;
    blockHeader.majorVersion        = GFD_BLOCK_HEADER_MAJOR;
    blockHeader.minorVersion        = GFD_BLOCK_HEADER_MINOR;

    blockHeader.dataSize   = size;  // following data block size in bytes, doesn't include this header

    return GFDWriteMemPPCData(fp, (GFD_BLOCK_HEADER_SIZE + 3) / 4, GFD_ELEMENT_SIZE_32, (u32 *) &blockHeader);
}

char *GFD_API GFDWriteMemGPUData(char *fp, u32 numElements, GFDElementSize elemSize, GFDEndianSwapMode swapMode, void *pData)
{
    size_t retWords = 0;

    // Set Swap Enable
    if(swapMode == GFD_ENDIAN_SWAP_MODE_8_IN_32)
    {
        u32 scale = GFD_ELEMENT_SIZE_32/elemSize;
        u32 elems = (numElements + scale - 1)/scale;

        // Swap Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);

        // Write data
        MEMCPY((u32*)pData, GFD_ELEMENT_SIZE_32, elems,  fp);

        // Revert Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);
    }
    else if((swapMode == (GFD_ENDIAN_SWAP_MODE_8_IN_32 | GFD_ENDIAN_SWAP_MODE_BIG)) && _GFD_LITTLE_ENDIAN_CPU)
    {
        u32 scale = GFD_ELEMENT_SIZE_32/elemSize;
        u32 elems = (numElements + scale - 1)/scale;

        // Swap Endian
        GFDEndianSwap(pData, numElements, elemSize);

        // Swap Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);

        // Write data
        MEMCPY((u32*)pData, GFD_ELEMENT_SIZE_32, elems,  fp);

        // Revert Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);

        // Revert Endian
        GFDEndianSwap(pData, numElements, elemSize);
    }
    else if((swapMode == GFD_ENDIAN_SWAP_MODE_BIG) && _GFD_LITTLE_ENDIAN_CPU)
    {
        // Swap Endian
        GFDEndianSwap(pData, numElements, elemSize);

        // Write data
        MEMCPY(pData, elemSize, numElements,  fp);

        // Revert Endian
        GFDEndianSwap(pData, numElements, elemSize);
    }
    else
    {
        // Write data
        MEMCPY(pData, elemSize, numElements,  fp);
    }

    return fp;
}

bool GFD_API GFDReadMemGPUData(void *pData, u32 numElements, GFDElementSize elemSize, GFDEndianSwapMode swapMode, char *fp)
{
    // read data
    memcpy( pData, fp, elemSize * numElements);
//	size_t retWords = fread( pData, elemSize, numElements , fp);

//	if(retWords != numElements)
//		return false;

    // Set Swap Enable
    if(swapMode == GFD_ENDIAN_SWAP_MODE_8_IN_32)
    {
        u32 scale = GFD_ELEMENT_SIZE_32/elemSize;
        u32 elems = (numElements + scale - 1)/scale;

        // Swap Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);
    }
    else if((swapMode == (GFD_ENDIAN_SWAP_MODE_8_IN_32 | GFD_ENDIAN_SWAP_MODE_BIG)) && _GFD_LITTLE_ENDIAN_CPU)
    {
        u32 scale = GFD_ELEMENT_SIZE_32/elemSize;
        u32 elems = (numElements + scale - 1)/scale;

        // Swap Endian
 		GFDEndianSwap((u32*)pData, elems, GFD_ELEMENT_SIZE_32);

        // Swap Endian
        GFDEndianSwap(pData, numElements, elemSize);
    }
    else if((swapMode == GFD_ENDIAN_SWAP_MODE_BIG) && _GFD_LITTLE_ENDIAN_CPU)
    {
    	// Swap Endian
        GFDEndianSwap(pData, numElements, elemSize);
    }
    return true;
}

char * GFD_API GFDWriteMemPadBlock(char *fp, u32 padSize)
{
    if(padSize < 0)
        return false;

    // write header for pad header
    fp = GFDWriteMemBlockHeader(fp, GFD_BLOCK_TYPE_PAD, padSize);

    // seek file pointer for padding
    fp += padSize;

    return fp;
}
