﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderConverterLib_ShaderConverterEmitterData_H__
#define __ShaderConverterLib_ShaderConverterEmitterData_H__


namespace EffectMaker {
namespace ShaderConverterLib {

    /// <summary>
    /// The emitter data structure.
    /// </summary>
    struct LIB_API ShaderConverterEmitterData
    {
        u8 *pBinaryHeader;
        u8 *pResEmitter;
        u32 shaderIndexOffset;
        u32 vertexShaderIndex;
        u32 pixelShaderIndex;
        u32 userVertexShaderIndex1;
        u32 userPixelShaderIndex1;
        u32 userVertexShaderIndex2;
        u32 userPixelShaderIndex2;
        s32 reservedShaderIndex;
        char *szOverrideShader;
        s32 iOverrideShaderLength;
    };

} // namespace ShaderConverterLib
} // namespace EffectMaker


#endif // __ShaderConverterLib_ShaderConverterEmitterData_H__
