﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderConverterLib_Messages_H__
#define __ShaderConverterLib_Messages_H__


namespace EffectMaker {
namespace ShaderConverterLib {

    /// <summary>Message to ask the application to open the specified text file.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_OpenTextFile, FilePath);

    /// <summary>Message to output profiler time measurement.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ProfilerTime, Tag, ElapsedTime);

    /// <summary>Message when shader compile error occurred.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ShaderCompileError, Destination, LogLevel, EmitterName, UserShaderDefine);

    /// <summary>Message when shader compile error occurred even without custom shader.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ShaderRecompileError, Destination, LogLevel, EmitterName);

    /// <summary>Message when shader compile warning occurred.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ShaderCompileWarning, Destination, LogLevel, EmitterName);

    /// <summary>Message for displaying shader compile error log.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ShaderCompileErrorLog, Destination, LogLevel, EmitterName, ErrorLog);

    /// <summary>Message when generated shader size exceeds the buffer size.</summary>
    DEFINE_MESSAGE(ShaderMsg_ShaderExceedsBufferSize, ShaderSize);

    /// <summary>Shader compile report message.</summary>
    DEFINE_MESSAGE(ShaderConverterMsg_ShaderCompileReport, Destination, LogLevel, ShaderCount, BufferSize);

    /// <summary>Message to output generated by user.</summary>
    DEFINE_MESSAGE(ShaderMsg_General, Destination, LogLevel, OutputMsg);

} // namespace ShaderConverterLib
} // namespace EffectMaker

#endif // __ShaderConverterLib_Messages_H__
