﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Manager;
using EffectMaker.BusinessLogic.Protocol;
using EffectMaker.Foundation.Utility;
using EffectMaker.UILogic.ViewModels;
using CommunicatorMessage = EffectMaker.Communicator.Message;

namespace EffectMaker.Application.TestDialog
{
    /// <summary>
    /// テストダイアログ(平林さん).
    /// </summary>
    public partial class HirabayashiTestDialog : Form
    {
        /// <summary>
        /// Initializes a new instance of the class.
        /// </summary>
        public HirabayashiTestDialog()
        {
            this.InitializeComponent();

            //// テスト用初期値設定コード
        }

        private void btnSendModel_Click(object sender, EventArgs e)
        {
            ViewerModelInfoMessage message = new ViewerModelInfoMessage()
            {
                MessageType = ModelInfoMessageType.Send,
                Guid = new Guid("{3DA270D7-C5F8-481b-AE7B-84B8B097A049}"),
                ModelName = "TestModel",
                BoneNames = new string[] { "TestBone" }
            };

            ModelInfoManager.ProcessMessageTest(message.GenerateBinary());
        }

        private void btnEndModel_Click(object sender, EventArgs e)
        {
            ViewerModelInfoMessage message = new ViewerModelInfoMessage()
            {
                MessageType = ModelInfoMessageType.End,
                Guid = new Guid("{3DA270D7-C5F8-481b-AE7B-84B8B097A049}"),
                ModelName = "TestModel",
                BoneNames = new string[] { "TestBone" }
            };

            ModelInfoManager.ProcessMessageTest(message.GenerateBinary());
        }

        private void btnRemoveModel_Click(object sender, EventArgs e)
        {
            ViewerModelInfoMessage message = new ViewerModelInfoMessage()
            {
                MessageType = ModelInfoMessageType.Remove,
                Guid = new Guid("{3DA270D7-C5F8-481b-AE7B-84B8B097A049}"),
                ModelName = "TestModel",
                BoneNames = new string[] { "TestBone" }
            };

            ModelInfoManager.ProcessMessageTest(message.GenerateBinary());
        }

        /// <summary>
        /// Viewerから送信されるモデル情報メッセージの再現です。
        /// </summary>
        private class ViewerModelInfoMessage
        {
            /// <summary>
            /// メッセージタイプを取得または設定します。
            /// </summary>
            public ModelInfoMessageType MessageType { get; set; }

            /// <summary>
            /// GUID を取得または設定します。
            /// </summary>
            public Guid Guid { get; set; }

            /// <summary>
            /// モデル名を取得または設定します。
            /// </summary>
            public string ModelName { get; set; }

            /// <summary>
            /// ボーン名を取得または設定します。
            /// </summary>
            public string[] BoneNames { get; set; }

            /// <summary>
            /// バイナリメッセージを生成します。
            /// </summary>
            /// <returns>バイナリメッセージを返します。</returns>
            public CommunicatorMessage GenerateBinary()
            {
                byte[] streamArray;

                char[] modelName = this.ModelName.ToCharArray();
                char[] boneName = this.BoneNames[0].ToCharArray();  // とりあえず 1 つだけ処理

                using (var stream = new System.IO.MemoryStream())
                using (var writer = new System.IO.BinaryWriter(stream))
                {
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)BusinessLogic.ViewerMessages.MessageTypes.ModelInfo);

                    long posMessageSize = stream.Position;
                    Foundation.Utility.BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)0);

                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)this.MessageType);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)0);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, this.Guid);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)1);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, modelName);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, Enumerable.Repeat((char)0, 260 * 2 - modelName.Length));
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)1);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, (uint)boneName.Length);
                    BinaryConversionUtility.ForProtocol.WriteStream(stream, boneName);

                    uint messageSize = (uint)stream.Position - 8;

                    stream.Position = posMessageSize;
                    Foundation.Utility.BinaryConversionUtility.ForProtocol.WriteStream(stream, messageSize);

                    streamArray = stream.ToArray();
                }

                CommunicatorMessage message = new CommunicatorMessage()
                {
                    Size = streamArray.Length,
                    Buffer = streamArray
                };

                return message;
            }
        };
    }
}
