﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.BusinessLogic.Protocol;
using EffectMaker.Communicator;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.Application.OptionPanes
{
    /// <summary>
    /// Viewer options.
    /// </summary>
    [DisplayOrder(2)]
    public partial class ViewerOptionPane : UserControl, IOptionPane
    {
        /// <summary>
        /// Initializes the ViewerOptionPane instance.
        /// </summary>
        public ViewerOptionPane()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// オプションウィンドウのTreeViewを再描画するdelegate
        /// </summary>
        public Action DrawTreeView
        {
            get;
            set;
        }

        /// <summary>
        /// Gets the identifier.
        /// </summary>
        public string Identifier
        {
            get { return "ViewerOptionPane"; }
        }

        /// <summary>
        /// Gets the parent identifier.
        /// </summary>
        public string ChildOf
        {
            get { return "UserConfig"; }
        }

        /// <summary>
        /// Gets the display name.
        /// </summary>
        public string DisplayName
        {
            get { return Properties.Resources.OptionPaneViewer; }
        }

        /// <summary>
        /// Called when initialized.
        /// </summary>
        public void OnInitialize()
        {
            ViewerOptions options = OptionStore.RootOptions.Viewer;

            // フレームレートコンボボックス設定
            this.cboFrameRate.Items.AddRange(new object[]
            {
                Properties.Resources.OptionViewerFrameRate60,
                Properties.Resources.OptionViewerFrameRate30,
                Properties.Resources.OptionViewerFrameRate20,
                Properties.Resources.OptionViewerFrameRate15
            });

            // ウインドウサイズコンボボックス設定
            this.cboWindowSize.Items.AddRange(new object[]
            {
                Properties.Resources.OptionViewerResolution1280_720,
                Properties.Resources.OptionViewerResolution640_480,
                Properties.Resources.OptionViewerResolution960_540
            });

            // 自動接続フラグのチェックを設定.
            this.chkAutoConnect.Checked = options.AutoConnect;

            int index = 0;

            if (options.FrameRate != null)
            {
                index = this.cboFrameRate.Items.IndexOf(options.FrameRate);
                if (index < 0)
                {
                    index = 0;
                }
            }

            this.cboFrameRate.SelectedIndex = index;

            index = 0;

            if (options.WindowSize != null)
            {
                index = this.cboWindowSize.Items.IndexOf(options.WindowSize);
                if (index < 0)
                {
                    index = 0;
                }
            }

            this.cboWindowSize.SelectedIndex = index;

            OptionUtil.SetCommentLabelState(this.lblViewerSizeComment);
        }

        /// <summary>
        /// Called when terminated.
        /// </summary>
        public void OnTerminate()
        {
        }

        /// <summary>
        /// Called when the Accept button is clicked.
        /// </summary>
        /// <returns>入力に不正がなければtrue,入力が不正であればfalse.</returns>
        public bool OnAccept()
        {
            ViewerOptions options = OptionStore.RootOptions.Viewer;

            options.AutoConnect = this.chkAutoConnect.Checked;

            options.FrameRate = (string)this.cboFrameRate.SelectedItem;
            options.WindowSize = (string)this.cboWindowSize.SelectedItem;

            // 自動接続のフラグを設定.
            MessageManager.Instance.IsAutoConnectEnabled = options.AutoConnect;

            return true;
        }

        /// <summary>
        /// Called when the Cancel button is clicked.
        /// </summary>
        public void OnCancel()
        {
        }

        /// <summary>
        /// ユーザーコンフィグが読み込まれた際に、その内容にUIを更新します。
        /// </summary>
        public void OnProjectSettingChanged()
        {
        }

        /// <summary>
        /// パス設定項目がないので常時trueを返します。
        /// </summary>
        /// <returns>
        /// 常時true.
        /// </returns>
        public bool OnValidationCheck()
        {
            return true;
        }

        /// <summary>
        /// プロジェクトコンフィグをファイル出力する際に各UIの内容を出力用インスタンスに収集します。
        /// </summary>
        public void OnExportProjectSetting()
        {
        }
    }
}
