﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.BusinessLogic.ProjectConfig;
using EffectMaker.BusinessLogic.Protocol;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.Application.OptionPanes
{
    /// <summary>
    /// Linear workflow options.
    /// </summary>
    [DisplayOrder(6)]
    public partial class LinearWorkflowOptionPane : UserControl, IOptionPane
    {
        /// <summary>
        /// Initializes the LinearWorkflowOptionPane instance.
        /// </summary>
        public LinearWorkflowOptionPane()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Gets the identifier.
        /// </summary>
        public string Identifier
        {
            get { return "LinearWorkflowOptionPane"; }
        }

        /// <summary>
        /// Gets the parent identifier.
        /// </summary>
        public string ChildOf
        {
            get { return "ProjectConfig"; }
        }

        /// <summary>
        /// Gets the display name.
        /// </summary>
        public string DisplayName
        {
            get { return Properties.Resources.OptionPaneLinearWorkflow; }
        }

        /// <summary>
        /// Called when initialized.
        /// </summary>
        public void OnInitialize()
        {
            LinearWorkflowOptions options = OptionStore.RootOptions.LinearWorkflow;
            EffectMakerProjectConfig config = OptionStore.ProjectConfig;

            OptionalMsgBoxSetting setting;
            var settingMap = OptionStore.RootOptions.Interface.OptionalMsgBoxSettings;

            if (settingMap.TryGetValue("LinearEditTextureWarning", out setting) == false)
            {
                setting = new OptionalMsgBoxSetting() { IsEnabled = true, DialogResult = DialogResult.OK };
                settingMap.Add("LinearEditTextureWarning", setting);
            }

            this.chkOptionsEditMode.Checked = config.LinearMode;
            this.chkOptionsWarningLoadingTextureDifferentMode.Checked = setting.IsEnabled;

            // オプショングループラベル
            this.grpOptions.Text = Properties.Resources.OptionLinearWorkflowOption;
            this.chkOptionsEditMode.Text = Properties.Resources.OptionLinearWorkflowLinearEditMode;
            this.chkOptionsWarningLoadingTextureDifferentMode.Text = Properties.Resources.OptionLinearWorkflowLinearEditTextureWarning;
        }

        /// <summary>
        /// Called when terminated.
        /// </summary>
        public void OnTerminate()
        {
        }

        /// <summary>
        /// Called when the Accept button is clicked.
        /// </summary>
        public void OnAccept()
        {
            LinearWorkflowOptions options = OptionStore.RootOptions.LinearWorkflow;
            EffectMakerProjectConfig config = OptionStore.ProjectConfig;

            config.LinearMode = this.chkOptionsEditMode.Checked;

            var settingMap = OptionStore.RootOptions.Interface.OptionalMsgBoxSettings;
            settingMap["LinearEditTextureWarning"].IsEnabled = this.chkOptionsWarningLoadingTextureDifferentMode.Checked;
        }

        /// <summary>
        /// Called when the Cancel button is clicked.
        /// </summary>
        public void OnCancel()
        {
        }

        /// <summary>
        /// ユーザーコンフィグが読み込まれた際に、その内容にUIを更新します。
        /// </summary>
        public void OnUserSettingChanged()
        {
            this.chkOptionsEditMode.Checked = OptionStore.ProjectConfig.LinearMode;
        }
    }
}
