﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.Application.OptionPanes
{
    /// <summary>
    /// Draw path options.
    /// </summary>
    [DisplayOrder(8)]
    public partial class DrawPathOptionPane : UserControl, IOptionPane
    {
        /// <summary>
        /// Initializes the DrawPathOptionPane instance.
        /// </summary>
        public DrawPathOptionPane()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Gets the identifier.
        /// </summary>
        public string Identifier
        {
            get { return "DrawPathOptionPane"; }
        }

        /// <summary>
        /// Gets the parent identifier.
        /// </summary>
        public string ChildOf
        {
            get { return "ProjectConfig"; }
        }

        /// <summary>
        /// Gets the display name.
        /// </summary>
        public string DisplayName
        {
            get { return Properties.Resources.OptionPaneDrawPath; }
        }

        /// <summary>
        /// Called when initialized.
        /// </summary>
        public void OnInitialize()
        {
            var drawPaths = OptionStore.ProjectConfig.DrawPaths;

            // ヘッダを設定
            this.lstDrawPath.Columns.Add("Id");
            this.lstDrawPath.Columns.Add("Text");

            // 描画パスリストを設定.
            foreach (var drawPath in drawPaths)
            {
                ListViewItem item = new ListViewItem(new string[]
                {
                    drawPath.Id.ToString(),
                    drawPath.Text
                });

                this.lstDrawPath.Items.Add(item);
            }

            // 列のサイズを更新
            this.lstDrawPath.AutoResizeColumns(ColumnHeaderAutoResizeStyle.ColumnContent);

            // 描画パス関連ラベル設定
            this.grpDrawPath.Text = Properties.Resources.OptionDrawPathDrawPath;
        }

        /// <summary>
        /// Called when option window is terminated.
        /// </summary>
        public void OnTerminate()
        {
        }

        /// <summary>
        /// Called when the Accept button is clicked.
        /// </summary>
        public void OnAccept()
        {
        }

        /// <summary>
        /// Called when the Cancel button is clicked.
        /// </summary>
        public void OnCancel()
        {
        }

        /// <summary>
        /// ユーザーコンフィグが読み込まれた際に、その内容にUIを更新します。
        /// </summary>
        public void OnUserSettingChanged()
        {
            this.lstDrawPath.Items.Clear();
            this.OnInitialize();
        }
    }
}
