﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.Foundation.Log;
using EffectMaker.Foundation.Utility;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// シェーダキャッシュディレクトリオプションを処理します。
    /// </summary>
    public class ShaderCacheDirectoryProcessor : CommandLineProcessorBase
    {
        /// <summary>
        /// シェーダキャッシュディレクトリです。
        /// </summary>
        private string shaderCacheDirectory;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="workingData">作業データ</param>
        /// <param name="shaderCacheDirectory">シェーダキャッシュディレクトリ</param>
        public ShaderCacheDirectoryProcessor(CommandLineWorkingData workingData, string shaderCacheDirectory)
            : base(workingData)
        {
            this.shaderCacheDirectory = shaderCacheDirectory;
        }

        /// <summary>
        /// エラーログを取得します。
        /// </summary>
        public override string ErrorReport { get { return string.Empty; } }

        /// <summary>
        /// 設定処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Setup()
        {
            // パスをフルパスに変換
            string fullpath = PathUtility.ToAbsolutePath(this.shaderCacheDirectory, TheApp.WorkingFolder);

            if (Directory.Exists(fullpath) == false)
            {
                Logger.Log(
                    "Console",
                    LogLevels.Error,
                    Properties.Resources.ConsoleMsgShaderCacheDirNotFound,
                    this.shaderCacheDirectory);

                return false;
            }

            OptionStore.RuntimeOptions.ShaderCacheDirectory = fullpath;

            return true;
        }

        /// <summary>
        /// コマンドライン処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Process()
        {
            return true;
        }

        /// <summary>
        /// 書き換えた設定などを復元します。
        /// </summary>
        public override void Cleanup()
        {
        }
    }
}
