﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Serialization;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// 常駐アセットリスト
    /// </summary>
    public class ResidentAssetList : IXmlDocSerializable
    {
        /// <summary>
        /// テクスチャ辞書
        /// </summary>
        public Dictionary<string, ulong?> TextureTable { get; set; }

        /// <summary>
        /// オリジナルプリミティブ辞書
        /// </summary>
        public Dictionary<string, ulong?> OriginalPrimitiveTable { get; set; }

        /// <summary>
        /// g3dプリミティブ辞書
        /// </summary>
        public Dictionary<string, ulong?> G3dPrimitiveTable { get; set; }

        /// <summary>
        /// 読み込み
        /// </summary>
        /// <param name="context">コンテキスト</param>
        /// <returns>成否</returns>
        public bool ReadXml(XmlDocSerializationContext context)
        {
            this.TextureTable = this.ReadDictionaryElement(context, "Texture", (Dictionary<string, ulong?>)null);
            this.OriginalPrimitiveTable = this.ReadDictionaryElement(context, "OriginalPrimitive", (Dictionary<string, ulong?>)null);
            this.G3dPrimitiveTable = this.ReadDictionaryElement(context, "G3dPrimitiveTable", (Dictionary<string, ulong?>)null);
            return this.TextureTable != null && this.OriginalPrimitiveTable != null && this.G3dPrimitiveTable != null;
        }

        /// <summary>
        /// 書き込み
        /// </summary>
        /// <param name="context">コンテキスト</param>
        /// <returns>成否</returns>
        public bool WriteXml(XmlDocSerializationContext context)
        {
            bool result = this.WriteDictionaryElement(context, "Texture", this.TextureTable);
            result &= this.WriteDictionaryElement(context, "OriginalPrimitive", this.OriginalPrimitiveTable);
            result &= this.WriteDictionaryElement(context, "G3dPrimitiveTable", this.G3dPrimitiveTable);

            return result;
        }
    }
}
