﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// スーパーストライプ(仮)
    /// </summary>
    [Serializable]
    public class StripeSuperUserData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public StripeSuperUserData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumDivisions = 0;
            this.ConnectionType = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 1.0f;
            this.DirInterpolation = 1.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 計算方式
        /// </summary>
        [DataModelPropertyGuid("b1706fc6-5ece-4e38-9694-9d946e20b932")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従
        /// </summary>
        [DataModelPropertyGuid("612d2e25-ed6c-4702-a8fe-22386e344c12")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプション
        /// </summary>
        [DataModelPropertyGuid("27fb423a-0ff5-4820-8bef-a41d3118e682")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリング
        /// </summary>
        [DataModelPropertyGuid("b1e719a6-95b7-4b31-857f-58f1309cef22")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 分割数
        /// </summary>
        [DataModelPropertyGuid("fa04e60e-5394-429b-bbac-129b9b171f96")]
        public int NumDivisions { get; set; }

        /// <summary>
        /// 接続タイプ
        /// </summary>
        [DataModelPropertyGuid("859cda81-6ec7-4ecf-831d-9e23a649745a")]
        public int ConnectionType { get; set; }

        /// <summary>
        /// 先端α
        /// </summary>
        [DataModelPropertyGuid("b958dc89-abef-4bd9-9855-475cbaa4df14")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端α
        /// </summary>
        [DataModelPropertyGuid("bda0b6ce-554d-4303-b4cf-9dc58de05816")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータ
        /// </summary>
        [DataModelPropertyGuid("6e474778-7daf-4301-8f77-059a8236d1e6")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率
        /// </summary>
        [DataModelPropertyGuid("43e2b9fc-bdab-4a2e-884c-5573248df2a6")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// ストライプタイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("c8fcf9d3-07b4-4b87-b30a-a1211e3e9c8f")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("ビルボードストライプ", 0),
                    new ComboBoxItemType("エミッタ行列ストライプ", 1),
                    new ComboBoxItemType("エミッタの上下に伸ばす", 2),
                };
            }
        }

        /// <summary>
        /// オプションタイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("ecfa1745-eae1-4c0b-95d1-830795133827")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("クロス", 1),
                };
            }
        }

        /// <summary>
        /// テクスチャ座標タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("155239db-3fc2-40c6-9f6b-2e1cbbd99cc5")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("全て貼る", 0),
                    new ComboBoxItemType("描画範囲に合わせて貼る", 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプ.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("e9d0faff-97a0-4d2c-bdba-df8d4245fbfa")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType("通常", 0),
                    new ComboBoxItemType("先端に繋ぐ", 1),
                    new ComboBoxItemType("エミッタに繋ぐ", 2),
                };
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.StripeSuperUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.ConnectionType = srcDataModel.ConnectionType;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "StripeType", this.StripeType);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "Option", this.Option);
            this.WriteElement(context, "TexCoordType", this.TexCoordType);
            this.WriteElement(context, "NumDivisions", this.NumDivisions);
            this.WriteElement(context, "ConnectionType", this.ConnectionType);
            this.WriteElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.WriteElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.WriteElement(context, "HistInterpolation", this.HistInterpolation);
            this.WriteElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.StripeType = this.ReadElement(context, "StripeType", this.StripeType);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.Option = this.ReadElement(context, "Option", this.Option);
            this.TexCoordType = this.ReadElement(context, "TexCoordType", this.TexCoordType);
            this.NumDivisions = this.ReadElement(context, "NumDivisions", this.NumDivisions);
            this.ConnectionType = this.ReadElement(context, "ConnectionType", this.ConnectionType);
            this.StartSliceAlpha = this.ReadElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.EndSliceAlpha = this.ReadElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.HistInterpolation = this.ReadElement(context, "HistInterpolation", this.HistInterpolation);
            this.DirInterpolation = this.ReadElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }
    }
}
