﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class EPStripeComplexBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static EPStripeComplexBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var ePStripeComplexBinary = new BinaryStructDefinition(typeof(EPStripeComplexData)) { HasBinaryHeader = false };

            // Output : calcType
            // Inputs : StripeType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StripeType", new Guid("1d3c8123-95a3-4bf5-bb07-7ab44d732cde"))
            );

            // Output : emitterFollow
            // Inputs : FollowEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (System.Int32)1) }),
                    new ConverterParam("DefaultOutput", (System.Int32)0)),
                null,
                new InputPropertyDefinition("FollowEmitter", new Guid("09593f1e-c554-476c-acdc-7ca78223f1cb"))
            );

            // Output : option
            // Inputs : Option
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Option", new Guid("b967ff49-7b62-4667-9e1a-cc12e370e995"))
            );

            // Output : texturing
            // Inputs : TexCoordType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TexCoordType", new Guid("843f273e-b333-4d71-a002-ac476e77c517"))
            );

            // Output : numDivide
            // Inputs : NumDivisions
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("NumDivisions", new Guid("1b8ce0f6-0ff6-482b-8212-07f72a3c6602"))
            );

            // Output : connectionType
            // Inputs : ConnectionType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConnectionType", new Guid("314bb50c-f16d-418e-879f-d3c1f34e9f1b"))
            );

            // Output : headAlpha
            // Inputs : StartSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StartSliceAlpha", new Guid("ed059251-8d42-4631-b7c8-28b51a5ca256"))
            );

            // Output : tailAlpha
            // Inputs : EndSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EndSliceAlpha", new Guid("7d709214-5f91-4db3-ba75-75a3b3a18448"))
            );

            // Output : histInterpolate
            // Inputs : HistInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistInterpolation", new Guid("9746660c-fab9-4081-a5f5-f982bbbfdc8c"))
            );

            // Output : dirInterpolate
            // Inputs : DirInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeComplexBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("DirInterpolation", new Guid("f2a22c20-70fe-47bd-8c83-f14fb01ba50c"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = ePStripeComplexBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private EPStripeComplexBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
