﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The user data data model class.
    /// </summary>
    [Serializable]
    public class CustomActionSetting7 : CustomActionSettingData
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionSetting7() :
            base()
        {
            this.Flag0 = 0x00000000;
            this.IntParam0 = 0;
            this.IntParam1 = 0;
            this.IntParam2 = 0;
            this.IntParam3 = 0;
            this.IntParam4 = 0;
            this.IntParam5 = 0;
            this.FloatParam0 = 0f;
            this.FloatParam1 = 0f;
            this.FloatParam2 = 0f;
            this.FloatParam3 = 0f;
            this.FloatParam4 = 0f;
            this.FloatParam5 = 0f;
            this.FloatParam6 = 0f;
            this.FloatParam7 = 0f;

            this.PostConstruct();
        }

        /// <summary>
        /// Get or set the flag value 0.
        /// </summary>
        [DataModelPropertyGuid("314f6176-71c5-4053-8e99-5c5e35e3c6c2")]
        public uint Flag0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 0.
        /// </summary>
        [DataModelPropertyGuid("4e82341e-88ad-4fba-87dd-edb7cf13f405")]
        public int IntParam0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 1.
        /// </summary>
        [DataModelPropertyGuid("eec7b478-0048-4608-a4d1-fffc8a012b60")]
        public int IntParam1 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 2.
        /// </summary>
        [DataModelPropertyGuid("25fea63d-9782-4392-9b89-6d29ac67707f")]
        public int IntParam2 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 3.
        /// </summary>
        [DataModelPropertyGuid("496c68f3-c359-4369-a65d-e618d1a42923")]
        public int IntParam3 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 4.
        /// </summary>
        [DataModelPropertyGuid("375581a0-921c-4c49-958c-3aa973e7bfd0")]
        public int IntParam4 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 5.
        /// </summary>
        [DataModelPropertyGuid("ce84d890-6110-4803-926a-c159cc40ea95")]
        public int IntParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 0.
        /// </summary>
        [DataModelPropertyGuid("196215b1-a96a-4a68-bb33-e999485fc4a5")]
        public float FloatParam0 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 1.
        /// </summary>
        [DataModelPropertyGuid("b31f0223-e309-4567-8ef7-673fc4577958")]
        public float FloatParam1 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 2.
        /// </summary>
        [DataModelPropertyGuid("1ebbf40e-2675-4d5d-8b5e-ac9902f91201")]
        public float FloatParam2 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 3.
        /// </summary>
        [DataModelPropertyGuid("e955c2bb-b64e-4188-b524-efb465a5b742")]
        public float FloatParam3 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 4.
        /// </summary>
        [DataModelPropertyGuid("4f44174f-f2c0-4eb9-9abe-26302b05a099")]
        public float FloatParam4 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 5.
        /// </summary>
        [DataModelPropertyGuid("9a4d5e91-760d-4613-9cfb-174d435a864c")]
        public float FloatParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 6.
        /// </summary>
        [DataModelPropertyGuid("83dc5ccc-21b8-4b16-87f1-4afb0ec8bfcb")]
        public float FloatParam6 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 7.
        /// </summary>
        [DataModelPropertyGuid("4919222c-c893-4111-9421-09785fd60128")]
        public float FloatParam7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionSetting7;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flag0 = srcDataModel.Flag0;
            this.IntParam0 = srcDataModel.IntParam0;
            this.IntParam1 = srcDataModel.IntParam1;
            this.IntParam2 = srcDataModel.IntParam2;
            this.IntParam3 = srcDataModel.IntParam3;
            this.IntParam4 = srcDataModel.IntParam4;
            this.IntParam5 = srcDataModel.IntParam5;
            this.FloatParam0 = srcDataModel.FloatParam0;
            this.FloatParam1 = srcDataModel.FloatParam1;
            this.FloatParam2 = srcDataModel.FloatParam2;
            this.FloatParam3 = srcDataModel.FloatParam3;
            this.FloatParam4 = srcDataModel.FloatParam4;
            this.FloatParam5 = srcDataModel.FloatParam5;
            this.FloatParam6 = srcDataModel.FloatParam6;
            this.FloatParam7 = srcDataModel.FloatParam7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flag0", this.Flag0);
            this.WriteElement(context, "IntParam0", this.IntParam0);
            this.WriteElement(context, "IntParam1", this.IntParam1);
            this.WriteElement(context, "IntParam2", this.IntParam2);
            this.WriteElement(context, "IntParam3", this.IntParam3);
            this.WriteElement(context, "IntParam4", this.IntParam4);
            this.WriteElement(context, "IntParam5", this.IntParam5);
            this.WriteElement(context, "FloatParam0", this.FloatParam0);
            this.WriteElement(context, "FloatParam1", this.FloatParam1);
            this.WriteElement(context, "FloatParam2", this.FloatParam2);
            this.WriteElement(context, "FloatParam3", this.FloatParam3);
            this.WriteElement(context, "FloatParam4", this.FloatParam4);
            this.WriteElement(context, "FloatParam5", this.FloatParam5);
            this.WriteElement(context, "FloatParam6", this.FloatParam6);
            this.WriteElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flag0 = this.ReadElement(context, "Flag0", this.Flag0);
            this.IntParam0 = this.ReadElement(context, "IntParam0", this.IntParam0);
            this.IntParam1 = this.ReadElement(context, "IntParam1", this.IntParam1);
            this.IntParam2 = this.ReadElement(context, "IntParam2", this.IntParam2);
            this.IntParam3 = this.ReadElement(context, "IntParam3", this.IntParam3);
            this.IntParam4 = this.ReadElement(context, "IntParam4", this.IntParam4);
            this.IntParam5 = this.ReadElement(context, "IntParam5", this.IntParam5);
            this.FloatParam0 = this.ReadElement(context, "FloatParam0", this.FloatParam0);
            this.FloatParam1 = this.ReadElement(context, "FloatParam1", this.FloatParam1);
            this.FloatParam2 = this.ReadElement(context, "FloatParam2", this.FloatParam2);
            this.FloatParam3 = this.ReadElement(context, "FloatParam3", this.FloatParam3);
            this.FloatParam4 = this.ReadElement(context, "FloatParam4", this.FloatParam4);
            this.FloatParam5 = this.ReadElement(context, "FloatParam5", this.FloatParam5);
            this.FloatParam6 = this.ReadElement(context, "FloatParam6", this.FloatParam6);
            this.FloatParam7 = this.ReadElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }
    }
}
